

package gov.va.med.tfs;


import gov.va.med.tfs.persistence.CreateFilterPersistenceManagerInterface;
import gov.va.med.tfs.persistence.CreateTemplatePersistenceManagerInterface;
import gov.va.med.tfs.persistence.DeletePersistenceManagerInterface;
import gov.va.med.tfs.persistence.ReadPersistenceManagerInterface;
import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaData;

import java.util.List;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;
import javax.xml.ws.BindingType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;


/**
 * Service Implementation Bean (SIB)
 *
 * HandlerChain - injects soap handler into framework
 * 
 * HandlerChain( file = "gov.va.med.tfs.config.soapHandler.xml" )
 * 
 */

@Stateless( mappedName = "WTFService" )
//wsdlc generated "/wsdls/TemplateFilterServiceService.wsdl" 
@WebService( portName = "TemplateFilterServicePort", serviceName = "WTFService", targetNamespace = "http://tfs.med.DNS   /", wsdlLocation = "wsdls/WTFService.wsdl", endpointInterface = "gov.va.med.tfs.TemplateFilterServiceInterface" )
@BindingType( "http://schemas.xmlsoap.org/wsdl/soap/http" )
@Interceptors( SpringBeanAutowiringInterceptor.class )
public class TemplateFilterService
    implements
        TemplateFilterServiceInterface,
        TemplateFilterServiceMBeanInterface

{

    public TemplateFilterService( )
    {

    }

    private Log logger = LogFactory.getLog( TemplateFilterService.class );

    @Autowired
    @Qualifier( "tfrReadable" )
    private ReadPersistenceManagerInterface tfrReadable;

    @Autowired
    @Qualifier( "tfrTemplateCreatable" )
    private CreateTemplatePersistenceManagerInterface createTemplateManager;

    @Autowired
    @Qualifier( "tfrFilterCreatable" )
    private CreateFilterPersistenceManagerInterface createFilterManager;

    @Autowired
    @Qualifier( "tfrDeletable" )
    private DeletePersistenceManagerInterface deleteManager;

    private String SERVICE_EXCEPTION = "Service Exception Encountered: ";
    private String FUNCTION_DISABLED = "Requested Function is Not Enabled";
    private static boolean createEnabled;
    private static boolean deleteEnabled;


    public void init( )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "initializing the template filter service." );
        }
    }


    public boolean isAlive( )
    {
        return true;
    }


    public List<String> getActiveTemplateIds( String vhimVersion )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered getActiveTemplateIds with vhimVersion " + vhimVersion );
        }

        List<String> activeTemplateIds = null;
        try
        {
            activeTemplateIds = tfrReadable.readActiveTemplateIds( vhimVersion );
        }
        catch ( Exception e )
        {
            logger.error( "++++++++++ getActiveTemplateIds Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        
        return activeTemplateIds;
    }


    public List<String> getActiveFilterIds( String vhimVersion )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered getActiveFilterIds with vhimVersion " + vhimVersion );
        }

        List<String> activeFilterIds = null;
        try
        {
            activeFilterIds = tfrReadable.readActiveFilterIds( vhimVersion );
        }
        catch ( Exception e )
        {
            logger.error( "++++++++++ getActiveFilterIds Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        
        return activeFilterIds;
    }


    public List<String> getVhimVersions( )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered getVhimVersions" );
        }

        List<String> versions = null;
        try
        {
            versions = tfrReadable.readVhimVersions();
        }
        catch ( Exception e )
        {
            System.out.println( "++++++++++ getVhimVersions Exception: " + e.getMessage() );
            logger.error( "++++++++++ getVhimVersions Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        
        return versions;
    }


    public FilterMetaData getFilterMetaData( String aFilterId )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered getFilterMetaData with FilterId " + aFilterId );
        }

        FilterMetaData filter = null;
        try
        {
            filter = tfrReadable.readFilterData( aFilterId );
        }
        catch ( Exception e )
        {
            logger.error( "++++++++++ getFilterMetaData Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        
        return filter;
    }


    public TemplateMetaData getTemplateMetaData( String aTemplateId )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered getTemplateMetaData with TemplateId " + aTemplateId );
        }

        TemplateMetaData template = null;
        try
        {
            template = tfrReadable.readTemplateData( aTemplateId );
        }
        catch ( Exception e )
        {
            logger.error( "++++++++++ getTemplateMetaData Exception: " + e.getStackTrace() );
            e.printStackTrace();
        }
        
        return template;
    }


    public String createFilterMetaData( FilterMetaData aFilterMetaData )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered createFilterMetaData with FilterId " + aFilterMetaData.getFilterId() );
        }
        
        String returnPersist = null;

        if ( !( isCreateEnabled() ) )
        {
            return FUNCTION_DISABLED;
        }

        try
        {
            setFilterDerivedAttributes( aFilterMetaData );
            returnPersist = createFilterManager.createFilterData( aFilterMetaData );
        }
        catch ( Exception e )
        {
            logger.error( "++++++++++ createFilterMetaData Exception: " + e.getStackTrace() );
            e.printStackTrace();
            returnPersist = SERVICE_EXCEPTION + e.getMessage();
        }

        return returnPersist;
    }


    private void setFilterDerivedAttributes( FilterMetaData aFilterMetaData )
    {
        aFilterMetaData.setDateAdded( new java.util.Date() );
    }


    public String createTemplateMetaData( TemplateMetaData aTemplateMetaData )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered createTemplateMetaData with TemplateId " + aTemplateMetaData.getTemplateId() );
        }
        
        String returnPersist = null;

        if ( !( isCreateEnabled() ) )
        {
            return FUNCTION_DISABLED;
        }

        try
        {
            setTemplateDerivedAttributes( aTemplateMetaData );
            returnPersist = createTemplateManager.createTemplateData( aTemplateMetaData );
        }
        catch ( Exception e )
        {
            logger.error( "++++++++++ createTemplateMetaData Exception: " + e.getStackTrace() );
            e.printStackTrace();
            returnPersist = SERVICE_EXCEPTION + e.getMessage();
        }

        return returnPersist;
    }


    private void setTemplateDerivedAttributes( TemplateMetaData aTemplateMetaData )
    {
        aTemplateMetaData.setDateAdded( new java.util.Date() );
    }


    public String deleteFilterMetaData( String aFilterId )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered deleteFilterMetaData with FilterId " + aFilterId );
        }
        
        String returnDelete = null;

        if ( !( isDeleteEnabled() ) )
        {
            return FUNCTION_DISABLED;
        }

        try
        {
            returnDelete = deleteManager.deleteFilterData( aFilterId );
        }
        catch ( Exception e )
        {
            logger.error( "++++++++++ deleteFilterMetaData Exception: " + e.getStackTrace() );
            e.printStackTrace();
            returnDelete = SERVICE_EXCEPTION + e.getMessage();
        }

        return returnDelete;
    }


    public String deleteTemplateMetaData( String aTemplateId )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered deleteTemplateMetaData with TemplateId " + aTemplateId );
        }
        
        String returnDelete = null;

        if ( !( isDeleteEnabled() ) )
        {
            return FUNCTION_DISABLED;
        }

        try
        {
            returnDelete = deleteManager.deleteTemplateData( aTemplateId );
        }
        catch ( Exception e )
        {
            logger.error( "++++++++++ deleteTemplateMetaData Exception: " + e.getStackTrace() );
            e.printStackTrace();
            returnDelete = SERVICE_EXCEPTION + e.getMessage();
        }

        return returnDelete;
    }


    public boolean isCreateEnabled( )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered isCreateEnabled: " + createEnabled );
        }

        return createEnabled;
    }


    public void setCreateEnabled( boolean createEnabledSwitch )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered setCreateEnabled: " + createEnabled );
        }
        createEnabled = createEnabledSwitch;
    }


    public boolean isDeleteEnabled( )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered isDeleteEnabled: " + deleteEnabled );
        }

        return deleteEnabled;
    }


    public void setDeleteEnabled( boolean deleteEnabledSwitch )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered setDeleteEnabled: " + deleteEnabled );
        }
        deleteEnabled = deleteEnabledSwitch;
    }
}
