readDomain(props.getProperty("cds.appserver.domaindir"))

#=======================================================================================
# deleteDataSource deletes a pre existing JDBC Datasource
#=======================================================================================
def deleteDataSource(dsName):
    try:
      cd('/')
      print "Deleting datasource: " + dsName
      delete(dsName,'JDBCSystemResource')
      print dsName + " deleted !"
    except:
      print dsName + " does not exist!"

def createURL(isWeblogicJDBCDriver, hostName, portNumber, dbName):
    if isWeblogicJDBCDriver == "oracleDriver":
       url='jdbc:oracle:thin:@'+hostName+':'+portNumber+':'+dbName #eg : jdbc:oracle:thin:@islhdr8:1521:hdr2d01
    else:
	   url='jdbc:bea:oracle://'+hostName+':'+portNumber #eg : jdbc:bea:oracle://islhdr8:1521
    return url

def setJDBCDriverParams(dataSource, user, hostName, portnumber, dbName):
     cd('/JDBCSystemResource/' + dataSource + '/JdbcResource/' + dataSource )
     cd('JDBCDriverParams/NO_NAME_0')
     create(dataSource,'Properties')
     cd('Properties/NO_NAME_0')
     create('user', 'Property')
     cd('Property/user')
     cmo.setValue(user)
     cd('../..')
     create('portNumber', 'Property')
     cd('Property/portNumber')
     cmo.setValue(portnumber)
     cd('../..')
     create('SID', 'Property')
     cd('Property/SID')
     cmo.setValue(dbName)
     cd('../..')
     create('serverName', 'Property')
     cd('Property/serverName')
     cmo.setValue(hostName)
#==================================================================================================
# Create JDBC Datasource
#==================================================================================================
def createPhysicalDataSource(dsName, jndiName, xaProtocol, xa_driver, url, user, passwd, target):
    print 'Creating DataSource ' + dsName     
    cd('/')        
    sysRes = create(dsName, "JDBCSystemResource")          
    cd('/JDBCSystemResources/' + dsName + '/JdbcResource/' + dsName)    
    dataSourceParams=create('dataSourceParams','JDBCDataSourceParams')
    cd('JDBCDataSourceParams/NO_NAME_0')    
    print "Setting JNDI Name : " + jndiName
    set('JNDIName',jndiName)
    set('GlobalTransactionsProtocol',xaProtocol)
    cd('/JDBCSystemResource/' + dsName + '/JdbcResource/' + dsName)
    driverParams=create(dsName,'JDBCDriverParams')
    driverParams.setUrl(url)
    if(xa_driver == "NonXADriver"):
	     # oracle.jdbc.OracleDriver (Oracle Thin Driver)
		 # weblogic.jdbc.oracle.OracleDriver (Weblogic NON XA Driver)
         driverParams.setDriverName( "weblogic.jdbc.oracle.OracleDriver" )
    else:
         if(xa_driver == "WeblogicXADriver"):
             # weblogic.jdbcx.oracle.OracleDataSource   (Weblogic XA Driver)
             driverParams.setDriverName( "weblogic.jdbcx.oracle.OracleDataSource" )
         else:
             # oracle.jdbc.xa.client.OracleXADataSource (Oracle XA Driver) 
             driverParams.setDriverName( "oracle.jdbc.xa.client.OracleXADataSource" )
    driverParams.setPasswordEncrypted(passwd)
    
    if xaProtocol != "None":
        cd('/JDBCSystemResource/' + dsName + '/JdbcResource/' + dsName)
        XAParams=create('XAParams','JDBCXAParams')
        XAParams.setKeepXaConnTillTxComplete(true)
        XAParams.setXaRetryDurationSeconds(300)
        XAParams.setXaTransactionTimeout(120)
        XAParams.setXaSetTransactionTimeout(true)
        XAParams.setXaEndOnlyOnce(true)
    assign('JDBCSystemResource',dsName,'Target', target)
    print dsName + ' successfully created !'
    print "............................................................................"
    return sysRes
#=======================================================================================
# Set Connection Pool Parameters
#=======================================================================================
def setJDBCConnectionPoolParameter(dsName, initialCapacity, maxCapacity, capacityIncrement):
    cd('/JDBCSystemResource/' + dsName + '/JdbcResource/' + dsName)
    connPoolParams=create('connPoolParams','JDBCConnectionPoolParams')
    connPoolParams.setInitialCapacity(Integer(initialCapacity).intValue())
    connPoolParams.setMaxCapacity(Integer(maxCapacity).intValue())
    connPoolParams.setCapacityIncrement(Integer(capacityIncrement).intValue())
    connPoolParams.setTestConnectionsOnReserve(true)
    connPoolParams.setTestTableName('SQL SELECT 1 FROM DUAL')
#=======================================================================================
# Update Domain
#=======================================================================================
def updateAll():
   updateDomain()
   closeDomain()
#=======================================================================================
# 1. HDR2 Data Source
#=======================================================================================
url=createURL("weblogicDriver", props.getProperty("cds.jdbc.host"), props.getProperty("cds.jdbc.port"), props.getProperty("cds.jdbc.dbname"))
clinicalDataSource = createPhysicalDataSource( "HDR2DataSource",
                          props.getProperty("cds.jdbc.dataSource.hdr2.jndiName"),
   						  "TwoPhaseCommit",
   						  "WeblogicXADriver",
                          url,
                          props.getProperty("cds.jdbc.username"),
   						  props.getProperty("cds.jdbc.password"),
   						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams("HDR2DataSource", props.getProperty("cds.jdbc.username"), props.getProperty("cds.jdbc.host"), props.getProperty("cds.jdbc.port"), props.getProperty("cds.jdbc.dbname"))
setJDBCConnectionPoolParameter("HDR2DataSource", "1", "15", "1")	
print ' jdbc mbean name ' + clinicalDataSource.getName()
#=======================================================================================
# 2. IMS Loader Data Source
#=======================================================================================
url=createURL("weblogicDriver", props.getProperty("ims.loader.jdbc.host"), props.getProperty("ims.loader.jdbc.port"), props.getProperty("ims.loader.jdbc.dbname"))
jdbc = createPhysicalDataSource( "ImsLoaderDataSource",
                          props.getProperty("cds.jdbc.dataSource.ims.loader.jndiName"),
				          "TwoPhaseCommit",
   						  "WeblogicXADriver",
						  url,
                          props.getProperty("ims.loader.jdbc.username"),
						  props.getProperty("ims.loader.jdbc.password"),
						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams("ImsLoaderDataSource", props.getProperty("ims.loader.jdbc.username"),props.getProperty("ims.loader.jdbc.host"), props.getProperty("ims.loader.jdbc.port"), props.getProperty("ims.loader.jdbc.dbname"))
setJDBCConnectionPoolParameter("ImsLoaderDataSource", "1", "15", "1")   
#=======================================================================================
# 3. IMS-PSIM VA Domain
#=======================================================================================
url=createURL("oracleDriver", props.getProperty("ims.va.jdbc.host"), props.getProperty("ims.va.jdbc.port"), props.getProperty("ims.va.jdbc.dbname"))
jdbc = createPhysicalDataSource( "ImsPsimVaDomainDataSource",
                          props.getProperty("cds.jdbc.dataSource.ims.va.jndiName"),
					      "TwoPhaseCommit",
   						  "OracleXADriver",
						  url,
                          props.getProperty("ims.va.jdbc.username"),
						  props.getProperty("ims.va.jdbc.password"),
						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams( "ImsPsimVaDomainDataSource", props.getProperty("ims.va.jdbc.username"),props.getProperty("ims.va.jdbc.host"), props.getProperty("ims.va.jdbc.port"), props.getProperty("ims.va.jdbc.dbname"))
setJDBCConnectionPoolParameter("ImsPsimVaDomainDataSource", "1", "15", "1")
#=======================================================================================
# 4. IMS-PSIM DoD Domain
#=======================================================================================
url=createURL("oracleDriver", props.getProperty("ims.dod.jdbc.host"), props.getProperty("ims.dod.jdbc.port"), props.getProperty("ims.dod.jdbc.dbname"))
jdbc = createPhysicalDataSource( "ImsPsimDodDomainDataSource",
                          props.getProperty("cds.jdbc.dataSource.ims.dod.jndiName"),
					      "TwoPhaseCommit",
   						  "OracleXADriver",
						  url,
                          props.getProperty("ims.dod.jdbc.username"),
						  props.getProperty("ims.dod.jdbc.password"),
						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams( "ImsPsimDodDomainDataSource", props.getProperty("ims.dod.jdbc.username"), props.getProperty("ims.dod.jdbc.host"), props.getProperty("ims.dod.jdbc.port"), props.getProperty("ims.dod.jdbc.dbname"))
setJDBCConnectionPoolParameter("ImsPsimDodDomainDataSource", "1", "15", "1")	
#=======================================================================================
# 5. IMS-PSIM Cross Domain
#=======================================================================================
url=createURL("oracleDriver", props.getProperty("ims.x.jdbc.host"), props.getProperty("ims.x.jdbc.port"), props.getProperty("ims.x.jdbc.dbname"))
jdbc = createPhysicalDataSource( "ImsPsimCrossDomainDataSource",
                          props.getProperty("cds.jdbc.dataSource.ims.x.jndiName"),
						 "TwoPhaseCommit",
   						  "OracleXADriver",
						  url,
                          props.getProperty("ims.x.jdbc.username"),
						  props.getProperty("ims.x.jdbc.password"),
						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams( "ImsPsimCrossDomainDataSource", props.getProperty("ims.x.jdbc.username"), props.getProperty("ims.x.jdbc.host"), props.getProperty("ims.x.jdbc.port"), props.getProperty("ims.x.jdbc.dbname"))
setJDBCConnectionPoolParameter("ImsPsimCrossDomainDataSource", "1", "15", "1")	
#=======================================================================================
# 6. IMS Queues
#=======================================================================================
url=createURL("oracleDriver", props.getProperty("ims.x.jdbc.host"), props.getProperty("ims.x.jdbc.port"), props.getProperty("ims.x.jdbc.dbname"))
jdbc = createPhysicalDataSource( "ImsQueuesDataSource",
                          " jdbc/gov/va/med/cds/hdrims/queues",
				          "TwoPhaseCommit",
   						  "OracleXADriver",
						  url,
                          props.getProperty("ims.x.jdbc.username"),
						  props.getProperty("ims.x.jdbc.password"),
						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams( "ImsQueuesDataSource", props.getProperty("ims.x.jdbc.username"), props.getProperty("ims.x.jdbc.host"), props.getProperty("ims.x.jdbc.port"), props.getProperty("ims.x.jdbc.dbname"))
setJDBCConnectionPoolParameter("ImsQueuesDataSource", "10", "100", "10")
#=======================================================================================
# 7. Hx Datasource
#=======================================================================================
url=createURL("weblogicDriver", props.getProperty("cds.hx.jdbc.host"), props.getProperty("cds.hx.jdbc.port"), props.getProperty("cds.hx.jdbc.dbname"))
jdbc = createPhysicalDataSource( "HistoricalDataSource",
                          props.getProperty("cds.hx.jdbc.dataSource.jndiName"),
				          "TwoPhaseCommit",
   						  "WeblogicXADriver",
		                  url,
                          props.getProperty("cds.hx.jdbc.username"),
						  props.getProperty("cds.hx.jdbc.password"),
						  props.getProperty("cds.appserver.target.server"))
setJDBCDriverParams( "HistoricalDataSource", props.getProperty("cds.hx.jdbc.username"), props.getProperty("cds.hx.jdbc.host"), props.getProperty("cds.hx.jdbc.port"), props.getProperty("cds.hx.jdbc.dbname"))
setJDBCConnectionPoolParameter("HistoricalDataSource", "1", "15", "1")
#=======================================================================================
updateAll()