#==========================================================================
# Open a domain template.
#==========================================================================

readTemplate( "wls.jar" )


#==========================================================================
# Configure the Administration Server and SSL port.
#==========================================================================
AdminServer=props.getProperty("cds.appserver.domainname")+'.admin'
cd('Servers/AdminServer')
set('Name', AdminServer)
set('ListenAddress','')
set('ListenPort', Integer(props.getProperty("cds.appserver.admin.port")).intValue())
ServerStart= create(props.getProperty("cds.appserver.domainname")+'.admin','ServerStart')
ServerStart.setArguments(props.getProperty("cds.appserver.target.server.startupargs"))

create('AdminServer','SSL')
cd('SSL/AdminServer')
set('Enabled', 'True')
set('ListenPort', 10000)
hideDumpStack("true")

#==========================================================================
# Define the user password for weblogic and weblogicdev
#==========================================================================

cd('/')
cd('Security/base_domain/User/weblogic')
cmo.setPassword('weblogicdev1')

cd('/')
cd('Security/base_domain/')
NewUser=create(props.getProperty("cds.appserver.admin.username"),'User')
NewUser.setPassword(props.getProperty("cds.appserver.admin.password"))

#==========================================================================
# Set Options:
#==========================================================================

setOption('CreateStartMenu', 'false')
setOption('ServerStartMode', 'dev')
setOption('OverwriteDomain', 'true')


machinename = create('localhost', 'Machine')

admin = props.getProperty("cds.appserver.domainname")+'.admin'
targetServer=props.getProperty("cds.appserver.target.server")
cd('/')
#cd("/Machines/localhost/NodeManager/localhost")
#print "setting attributes for mbean type NodeManager"
#set("ListenAddress", "localhost")

if (targetServer != admin):
  cd('/')
  create(props.getProperty("cds.appserver.target.server"), 'Server')
  cd('Server/'+props.getProperty("cds.appserver.target.server"))
  set('ListenPort', Integer(props.getProperty("cds.appserver.target.port")).intValue()) 
  set('ListenAddress', '')
  set('Machine',machinename)
  ServerStart= create(props.getProperty("cds.appserver.target.server"),'ServerStart')
  ServerStart.setArguments(props.getProperty("cds.appserver.target.server.startupargs"))
#=======================================================================================
# Create and configure a cluster and assign the Managed Servers to that cluster.
#=======================================================================================
"""
cd('/')
create('CdsCluster', 'Cluster')
assign('Server', props.getProperty("cds.appserver.target.server"),'Cluster','CdsCluster')
cd('Cluster/CdsCluster')
set('MulticastAddress', '237.0.0.101')
set('MulticastPort', 8050)
set('WeblogicPluginEnabled', 'true')
"""
#==========================================================================
# Write the domain and close the domain template.
#==========================================================================

writeDomain(props.getProperty("cds.appserver.domaindir"))
closeTemplate()

