

package gov.va.med.tfs.junit.runners;


import java.util.Comparator;

import org.junit.runner.Description;


public class DependancyComparator
    implements
        Comparator<Description>
{

    public int compare( Description d1, Description d2 )
    {
        if ( d2.getAnnotation( RunnerUtils.AFTER_TESTS_ONCE ) != null )
            return RunnerUtils.LOW;

        if ( d2.getAnnotation( RunnerUtils.BEFORE_TESTS_ONCE ) != null )
            return RunnerUtils.HIGH;

        int o1 = ( d1.getAnnotation( RunnerUtils.MARKER_CLASS ) != null ) ? ( d1.getAnnotation( RunnerUtils.MARKER_CLASS ) ).order() : 0;
        int o2 = ( d2.getAnnotation( RunnerUtils.MARKER_CLASS ) != null ) ? ( d2.getAnnotation( RunnerUtils.MARKER_CLASS ) ).order() : 0;
        return o1 - o2;

    }
}
