

package gov.va.med.tfs.client.webservice;


import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;


@WebServiceClient( name = "WTFService", wsdlLocation = "file:WTFService.wsdl", targetNamespace = "http://tfs.med.DNS   /" )
public class WTFServiceLocator
    extends
        Service
{

    public final static QName SERVICE = new QName( "http://tfs.med.DNS   /", "WTFService" );
    public final static QName TemplateFilterServicePort = new QName( "http://tfs.med.DNS   /", "TemplateFilterServicePort" );


    public WTFServiceLocator( URL wsdlLocation )
    {
        super( wsdlLocation, SERVICE );
    }


    public WTFServiceLocator( URL wsdlLocation, QName serviceName )
    {
        super( wsdlLocation, serviceName );
    }


    //This constructor requires JAX-WS API 2.2. You will need to endorse the 2.2
    //API jar or re-run wsdl2java with "-frontend jaxws21" to generate JAX-WS 2.1
    //compliant code instead.
    public WTFServiceLocator( URL wsdlLocation, WebServiceFeature... features )
    {
        super( wsdlLocation, SERVICE, features );
    }


    //This constructor requires JAX-WS API 2.2. You will need to endorse the 2.2
    //API jar or re-run wsdl2java with "-frontend jaxws21" to generate JAX-WS 2.1
    //compliant code instead.
    public WTFServiceLocator( URL wsdlLocation, QName serviceName, WebServiceFeature... features )
    {
        super( wsdlLocation, serviceName, features );
    }


    /**
     *
     * @return
     *     returns TemplateFilterServiceInterface
     */
    @WebEndpoint( name = "TemplateFilterServicePort" )
    public TemplateFilterServiceInterface getTemplateFilterServicePort( )
    {
        return super.getPort( TemplateFilterServicePort, TemplateFilterServiceInterface.class );
    }


    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns TemplateFilterServiceInterface
     */
    @WebEndpoint( name = "TemplateFilterServicePort" )
    public TemplateFilterServiceInterface getTemplateFilterServicePort( WebServiceFeature... features )
    {
        return super.getPort( TemplateFilterServicePort, TemplateFilterServiceInterface.class, features );
    }

}
