

package gov.va.med.tfs.client;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.FilterServiceInterface;
import gov.va.med.cds.template.TemplateServiceException;
import gov.va.med.cds.template.TemplateServiceInterface;
import gov.va.med.tfs.client.webservice.FilterMetaData;
import gov.va.med.tfs.client.webservice.TemplateFilterServiceInterface;
import gov.va.med.tfs.client.webservice.TemplateMetaData;
import gov.va.med.tfs.mapping.tfstocds.FilterMetaDataMapper;
import gov.va.med.tfs.mapping.tfstocds.TemplateMetaDataMapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;


public class WtfServiceManagement
    implements
        TemplateServiceInterface,
        FilterServiceInterface
{
    private static Log logger = LogFactory.getLog( WtfServiceManagement.class );

    private TemplateFilterServiceInterface tfsService = null;


    @Override
    public List<String> getActiveFilterIds( String aVhimVersion )
    {
        List<String> activeFilterIdsList = null;

        try
        {

            activeFilterIdsList = tfsService.getActiveFilterIds( aVhimVersion );

        }
        catch ( Exception e )
        {
            logger.error( "WtfServiceManagement getActiveFilterIds Exception: " + e.getMessage() );
            throw new TemplateServiceException( ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, e, aVhimVersion, e.getMessage() );
        }
        return activeFilterIdsList;
    }


    @Override
    public List<String> getActiveTemplateIds( String aVhimVersion )
    {
        List<String> activeTemplateIdsList = null;

        try
        {

            activeTemplateIdsList = tfsService.getActiveTemplateIds( aVhimVersion );

        }
        catch ( Exception e )
        {
            logger.error( "WtfServiceManagement getActiveTemplateIds Exception: " + e.getMessage() );
            throw new TemplateServiceException( ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, e, aVhimVersion, e.getMessage() );
        }
        return activeTemplateIdsList;
    }


    @Override
    public gov.va.med.cds.clinicaldata.FilterMetaData getFilterMetaData( String aFilterId )
    {
        gov.va.med.cds.clinicaldata.FilterMetaData cdsFilterMetaData = null;

        try
        {
            FilterMetaData tfsFilterMetaData = tfsService.getFilterMetaData( aFilterId );
            if ( tfsFilterMetaData != null )
            {
                cdsFilterMetaData = FilterMetaDataMapper.getInstance().map( tfsFilterMetaData );
            }
        }
        catch ( Exception e )
        {
            logger.error( "WtfServiceManagement getFilterMetaData Exception: " + e.getMessage() );
            throw new TemplateServiceException( ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, e, aFilterId, e.getMessage() );
        }

        return cdsFilterMetaData;
    }


    @Override
    public gov.va.med.cds.clinicaldata.TemplateMetaData getTemplateMetaData( String aTemplateId )
    {
        gov.va.med.cds.clinicaldata.TemplateMetaData cdsTemplateMetaData = null;

        try
        {
            TemplateMetaData tfsTemplateMetaData = tfsService.getTemplateMetaData( aTemplateId );
            if ( tfsTemplateMetaData != null )
            {
                cdsTemplateMetaData = TemplateMetaDataMapper.getInstance().map( tfsTemplateMetaData );
            }
        }
        catch ( Exception e )
        {
            logger.error( "WtfServiceManagement getTemplateMetaData Exception: " + e.getMessage() );
            throw new TemplateServiceException( ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, e, aTemplateId, e.getMessage() );
        }

        return cdsTemplateMetaData;
    }


    @Override
    public List<String> getVhimVersions( )
    {
        List<String> vhimVersionsList = null;

        try
        {

            vhimVersionsList = tfsService.getVhimVersions();

        }
        catch ( Exception e )
        {
            logger.error( "WtfServiceManagement getVhimVersions Exception: " + e.getMessage() );
            throw new TemplateServiceException( ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, e, "", e.getMessage() );
        }
        return vhimVersionsList;
    }


    @Override
    public boolean isAlive( )
    {
        try
        {
            return tfsService.isAlive();
        }
        catch ( Exception e )
        {
            logger.error( "WtfServiceManagement isAlive Exception: " + e.getMessage() );
            return false;
        }
    }


    public TemplateFilterServiceInterface getTfsService( )
    {
        return tfsService;
    }


    public void setTfsService( TemplateFilterServiceInterface tfsService )
    {
        this.tfsService = tfsService;
    }


    @Override
    public void initialize( )
    {
        if ( ( tfsService != null ) && isAlive() )
        {
            logger.debug( "WtfServiceManagement isAlive() is true" );
        }
        else
        {
            logger.error( "WtfServiceManagement isAlive() failed" );
            throw new TemplateServiceException( ErrorCodeEnum.VTS_SERVICE_FAILED, null, "isAlive() failed TFS Service is unavailable" );
        }

    }

}
