

package gov.va.med.cds.socket.server;


import gov.va.med.cds.util.MllpUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.junit.Test;

public class MinaClientHandlerDataTest
    extends
        IoHandlerAdapter
{

    private static final Log LOGGER = LogFactory.getLog( MinaClientHandlerDataTest.class );
    private IoBuffer values;
    public void setValues(IoBuffer values) {
		this.values = values;
	}


	private boolean finished;
    private String response = null;


    public String getResponse() {
		return response;
	}

    public MinaClientHandlerDataTest(){
    	super();
    }
   
    public boolean isFinished( )
    {
        return finished;
    }


    @Override
    public void sessionOpened( IoSession session )
    {
        session.write( values );
    }


    @Override
    public void messageReceived( IoSession session, Object message )
    {

        ByteBuffer buffer = ByteBuffer.allocate( ( ( ( IoBuffer )message ).limit() ) );

        int index = 0;

        do
        {
            buffer.put( index, ( ( IoBuffer )message ).get( index ) );
            index++ ;
        }
        while ( index < ( ( IoBuffer )message ).limit() );
        
        setResponse(new String( buffer.array() ));

       LOGGER.info( "Message received in the client.." + response );

    }


    private void setResponse(String response) {
		this.response = response;
	}


	@Override
    public void exceptionCaught( IoSession session, Throwable cause )
    {
        session.close( true );
    }


    private String decodeMllp( String message )
    {
        return new String( MllpUtil.decode( new ByteBuffer[] { ByteBuffer.wrap( message.getBytes() ) }, Charset.forName( "ISO-8859-1" ),
                        Charset.defaultCharset() ).array() );
    }
    @Test
    public void foo(){
    	
    }
}