

package gov.va.med.cds.client.proxy;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.testharness.AbstractLoggingTest;
import gov.va.med.cds.util.MllpUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.junit.runner.RunWith;


/**
 * This test will ensure socket based client proxy is operational.
 * 
 * 
 */

@RunWith( SuiteAwareRunner.class )
public class MllpSocketBasedClientProxyTest
    extends
        AbstractLoggingTest
{
    private static final Log logger = LogFactory.getLog( MllpSocketBasedClientProxyTest.class );


    /**
     * Test sendMessage on the MllpSocketBasedClientProxy
     * without specifying the properties
     * 
     */
    @Test( expected = IllegalArgumentException.class )
    @Suite( groups = { "checkintest" } )
    public void testSendMessageException( )
    {
        String msg = "MllpSocketBasedClientProxyTest ACK Message";
        String encMsg = ( char )MllpUtil.SOB + msg + ( char )MllpUtil.EOB + ( char )MllpUtil.CR;
        //       Properties properties = new Properties();

        MllpSocketBasedClientProxy mllpSocketProxy = null;
        mllpSocketProxy = new MllpSocketBasedClientProxy();
        mllpSocketProxy.sendMessage( encMsg, null );
    }

}
