

package gov.va.med.cds.scheduler;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import gov.va.med.cds.exception.CensusTransformAckException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.scheduler.persistence.CensusTransformationAcknowledgementPersistenceInterface;


public class CensusTransformAcknowledgementJob
    extends
        AbstractCensusQuartzJobBean
{
    private static Log logger = LogFactory.getLog( CensusTransformAcknowledgementJob.class );
    private static final String CENSUS_TRANSACK_PM_BEAN = "censusTransformationAcknowledgementPersistenceManager";

    private CensusTransformationAcknowledgementPersistenceInterface censusTransformationAcknowledgementPersistenceManager;


    @Override
    protected void executeInternal( JobExecutionContext context )
        throws JobExecutionException
    {
        loadApplicationContext( context );

        try
        {
            logger.info( "executing Census transformation ack quartz job..." );
            
            censusTransformationAcknowledgementPersistenceManager = ( CensusTransformationAcknowledgementPersistenceInterface )appCtx
                            .getBean( CENSUS_TRANSACK_PM_BEAN );

            if ( null == censusTransformationAcknowledgementPersistenceManager )
            {
                logger.error( ErrorCodeEnum.UNABLE_TO_LOAD_FROM_APP_CONTEXT );
                throw new CensusTransformAckException( ErrorCodeEnum.UNABLE_TO_LOAD_FROM_APP_CONTEXT, CENSUS_TRANSACK_PM_BEAN );
            }

            censusTransformationAcknowledgementPersistenceManager.sendAckForTransformedCensusReport();
        }
        catch ( Exception e )
        {
            logger.error( "Error in executeInternal " + e );
            throw new JobExecutionException( e );
        }
    }
}
