package gov.va.med.cds.mediator.xml.transform.saxonextensions;

import gov.va.med.cds.hapi.HL7Utility;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;


public class Hl7UtilityGetSendingFacilityExtFunc extends ExtensionFunctionDefinition {

	private static final long serialVersionUID = 8279443893871153379L;
	private static final StructuredQName qName = new StructuredQName("", NamespaceConstant.SAXON, "get-sendingfacility");
	
	@Override
	public StructuredQName getFunctionQName() {
		
		return qName;
	}

	@Override
	public SequenceType[] getArgumentTypes() {
		
		return new SequenceType[]{SequenceType.SINGLE_ITEM, SequenceType.SINGLE_STRING};

	}

	@Override
	public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
		
		return SequenceType.SINGLE_STRING;
	}
	

	@Override
	public ExtensionFunctionCall makeCallExpression() {
		
		return new SendingFacilityCall();
	}
	
	private static class SendingFacilityCall extends ExtensionFunctionCall{

	
		private static final long serialVersionUID = -8014215412592918959L;

		@Override
		public Sequence call(XPathContext context, Sequence[] arguments)
				throws XPathException {
			
			ObjectValue objV = (ObjectValue)arguments[0];
			HL7Utility hl7util = (HL7Utility)objV.getObject();
			LazySequence lz = (LazySequence)arguments[1];
			String assigningFacility = lz.head().getStringValue();
			
			
			return StringValue.makeStringValue(hl7util.getSendingFacility(assigningFacility));
			
		}

	}

}
