

package gov.va.med.cds.mediator.work.hapi;


import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.mediator.work.WorkerInterface;


public class RegisterHL7DataWithWorkStateWork
    implements
        WorkerInterface
{

    private String terserPath;

    private String wsnDataName;

    private String wsnHl7Support;


    public void doWork( WorkStateInterface workState )
    {
        try
        {
            HL7SupportInterface hl7Support = ( HL7SupportInterface )workState.locateWorkState( wsnHl7Support );
            String data = hl7Support.getMessageData( terserPath );
            workState.registerWorkState( wsnDataName, data );
        }
        catch ( Exception e )
        {
            workState.addException( e );
        }
    }


    public void setTerserPath( String terserPath )
    {
        this.terserPath = terserPath;
    }


    public void setWsnDataName( String wsnDataName )
    {
        this.wsnDataName = wsnDataName;
    }


    public void setWsnHl7Support( String wsnHl7Support )
    {
        this.wsnHl7Support = wsnHl7Support;
    }

}
