

package gov.va.med.cds.mediator.work.hapi;


import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.work.TemplateInformation;
import gov.va.med.cds.mediator.work.TemplateValidator;
import gov.va.med.cds.mediator.work.WorkStateInterface;


public class HL7XmlToVhimCreateXmlWork
    extends
        AbstractHl7XmlTransformerWork
{
    private String wsnTemplateInformation;
    private TemplateValidator validator;


	public void doWork( WorkStateInterface workState )
    {
        try
        {
            HL7SupportInterface hl7Support = ( HL7SupportInterface )workState.locateWorkState( this.wsnHl7Support );
            String hl7Xml = hl7Support.toXml();
            TemplateInformation templateInformation = templateInformationMap.get( hl7Support.getSendingApplication() );
            if ( templateInformation == null )
            {
            	throw new RuntimeException( "sendingApplication is not in templateInformationMap: " + hl7Support.getSendingApplication() );
            }
            String xsltStylesheet = templateInformation.getStylesheet();

            String vhimRequest = xsltHelper.transformMessageAsString( hl7Xml, xsltStylesheet );

            validator.validate( vhimRequest, templateInformation.getTemplateName() );
            
            workState.registerWorkState( this.wsnTemplateInformation, templateInformation );
            
            workState.registerWorkState( this.wsnVhimRequest, vhimRequest );
        }
        catch ( Exception e )
        {
            workState.addException( e );
        }
    }


    public String getWsnTemplateInformation( )
    {
        return wsnTemplateInformation;
    }


    public void setWsnTemplateInformation( String wsnTemplateInformation )
    {
        this.wsnTemplateInformation = wsnTemplateInformation;
    }


	public void setValidator(TemplateValidator validator) 
	{
		this.validator = validator;
	}
}
