

package gov.va.med.cds.mediator.persistence;


import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;

import org.springframework.orm.hibernate4.HibernateOperations;


public class HibernateHl7AuditDao
    implements
        Hl7AuditDaoInterface
{
    private HibernateOperations hl7AuditHibernateTemplate;


    public void addMessage( String messageControlId, String message )
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( message );

        String messageType = hl7Support.getMessageType();
        String messageDateTime = hl7Support.getMessageDateTime();

        Hl7MessageLog Hl7MessageLog = new Hl7MessageLog( null, message, messageControlId, messageDateTime, messageType );

        // persist the message in HL7 message log
        hl7AuditHibernateTemplate.save( Hl7MessageLog );
    }


    public void setHl7AuditHibernateTemplate( HibernateOperations hl7AuditHibernateTemplate )
    {
        this.hl7AuditHibernateTemplate = hl7AuditHibernateTemplate;
    }
}
