package gov.va.med.cds.junit.runners;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to mark methods that should belong to different types of test groups
 * Use the cds.test.groups environment variable to specify groups.</p> 
 * Example: <code> mvn clean install -Plocal <i>Dcds.test.groups=checkin</i></code></p>
 * This should look familiar.
 * 
 * @author DNS   sovar
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface AfterTestsOnce {}
