package gov.va.med.cds.hapi.extension.message;

import org.apache.commons.logging.LogFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.RDS_O13_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;

/**
 * <p>Represents a RDS_O13 message structure (see chapter 4). This structure contains the 
 * following elements: </p>
 * 0: MSH (Message Header) <b></b><br>
 * 1: NTE (Notes and Comments) <b>optional repeating</b><br>
 * 2: RDS_O13_PATIENT (a Group object) <b>optional </b><br>
 * 3: RDS_O13_ORDER (a Group object) <b>repeating</b><br>
 */
public class RDS_O13 extends AbstractMessage  {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** 
	 * Creates a new RDS_O13 Group with custom ModelClassFactory.
	 */
	public RDS_O13(ModelClassFactory factory) {
	   super(factory);
	   init(factory);
	}

	/**
	 * Creates a new RDS_O13 Group with DefaultModelClassFactory. 
	 */ 
	public RDS_O13() { 
	   super(new DefaultModelClassFactory());
	   init(new DefaultModelClassFactory());
	}

	private void init(ModelClassFactory factory) {
	   try {
	      this.add(MSH.class, true, false);
	      this.add(NTE.class, false, true);
	      this.add(RDS_O13_PATIENT.class, false, false);
	      this.add(RDS_O13_ORDER.class, true, true);
	   } catch(HL7Exception e) {
	      LogFactory.getLog(this.getClass()).error("Unexpected error creating RDS_O13 - this is probably a bug in the source code generator.", e);
	   }
	}

	/**
	 * Returns MSH (Message Header) - creates it if necessary
	 */
	public MSH getMSH() { 
	   MSH ret = null;
	   try {
	      ret = (MSH)this.get("MSH");
	   } catch(HL7Exception e) {
	      LogFactory.getLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	      throw new RuntimeException(e);
	   }
	   return ret;
	}

	/**
	 * Returns  first repetition of NTE (Notes and Comments) - creates it if necessary
	 */
	public NTE getNTE() { 
	   NTE ret = null;
	   try {
	      ret = (NTE)this.get("NTE");
	   } catch(HL7Exception e) {
	      LogFactory.getLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	      throw new RuntimeException(e);
	   }
	   return ret;
	}

	/**
	 * Returns a specific repetition of NTE
	 * (Notes and Comments) - creates it if necessary
	 * throws HL7Exception if the repetition requested is more than one 
	 *     greater than the number of existing repetitions.
	 */
	public NTE getNTE(int rep) throws HL7Exception { 
	   return (NTE)this.get("NTE", rep);
	}

	/** 
	 * Returns the number of existing repetitions of NTE 
	 */ 
	public int getNTEReps() { 
	    int reps = -1; 
	    try { 
	        reps = this.getAll("NTE").length; 
	    } catch (HL7Exception e) { 
	        String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
	        LogFactory.getLog(this.getClass()).error(message, e); 
	        throw new RuntimeException(message);
	    } 
	    return reps; 
	} 

	/**
	 * Returns RDS_O13_PATIENT (a Group object) - creates it if necessary
	 */
	public RDS_O13_PATIENT getPATIENT() { 
	   RDS_O13_PATIENT ret = null;
	   try {
	      ret = (RDS_O13_PATIENT)this.get("PATIENT");
	   } catch(HL7Exception e) {
	      LogFactory.getLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	      throw new RuntimeException(e);
	   }
	   return ret;
	}

	/**
	 * Returns  first repetition of RDS_O13_ORDER (a Group object) - creates it if necessary
	 */
	public RDS_O13_ORDER getORDER() { 
	   RDS_O13_ORDER ret = null;
	   try {
	      ret = (RDS_O13_ORDER)this.get("ORDER");
	   } catch(HL7Exception e) {
	      LogFactory.getLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	      throw new RuntimeException(e);
	   }
	   return ret;
	}

	/**
	 * Returns a specific repetition of RDS_O13_ORDER
	 * (a Group object) - creates it if necessary
	 * throws HL7Exception if the repetition requested is more than one 
	 *     greater than the number of existing repetitions.
	 */
	public RDS_O13_ORDER getORDER(int rep) throws HL7Exception { 
	   return (RDS_O13_ORDER)this.get("ORDER", rep);
	}

	/** 
	 * Returns the number of existing repetitions of RDS_O13_ORDER 
	 */ 
	public int getORDERReps() { 
	    int reps = -1; 
	    try { 
	        reps = this.getAll("ORDER").length; 
	    } catch (HL7Exception e) { 
	        String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
	        LogFactory.getLog(this.getClass()).error(message, e); 
	        throw new RuntimeException(message);
	    } 
	    return reps; 
	}
		
}
