

package gov.va.med.cds.hapi.extension.message;


import org.apache.commons.logging.LogFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QPD;
import ca.uhn.hl7v2.model.v24.segment.QRD;
import ca.uhn.hl7v2.model.v24.segment.RCP;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import gov.va.med.cds.hapi.extension.CustomRequestHl7ModelClassFactory;


/**
 * <p>
 * Represents a QRY_Q01 message structure (see chapter 5). This structure contains the following elements:
 * </p>
 * 0: MSH (Message Header) <b></b><br>
 * 1: QRD (Original-Style Query Definition) <b></b><br>
 * 2: QRF (Original Style Query Filter) <b>optional </b><br>
 * 3: DSC (Continuation Pointer) <b>optional </b><br>
 */
public class QRY_Q01
    extends
        AbstractMessage
{

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	/**
     * Creates a new RSP_K11 Group with custom ModelClassFactory.
     */
    public QRY_Q01( ModelClassFactory factory )
    {
        super( factory );
        init( factory );
    }


    /**
     * Creates a new RSP_K11 Group with DefaultModelClassFactory.
     */
    public QRY_Q01( )
    {
        super( new CustomRequestHl7ModelClassFactory() );
        init( new CustomRequestHl7ModelClassFactory() );
    }


    private void init( ModelClassFactory factory )
    {
        try
        {
            this.add( MSH.class, false, false );
            this.add( QPD.class, false, false );
            this.add( RCP.class, false, false );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error creating RSP_K11 - this is probably a bug in the source code generator.", e );
        }
    }


    /**
     * Returns MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH( )
    {
        MSH ret = null;
        try
        {
            ret = ( MSH )this.get( "MSH" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    /**
     * Returns QRD (Original-Style Query Definition) - creates it if necessary
     */
    public QRD getQRD( )
    {
        QRD ret = null;
        try
        {
            ret = ( QRD )this.get( "QRD" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }


    public RCP getRCP( )
    {
        RCP ret = null;
        try
        {
            ret = ( RCP )this.get( "RCP" );
        }
        catch ( HL7Exception e )
        {
            LogFactory.getLog( this.getClass() ).error(
                            "Unexpected error accessing data - this is probably a bug in the source code generator.", e );
            throw new RuntimeException( e );
        }
        return ret;
    }

}
