

package gov.va.med.cds.hapi.extension;


import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;


/**
 * @author DNS   egberb
 * 
 * Factory class used to get custom CDS model classes from the HAPI pipe parser.
 */
public class CustomCdsModelClassFactory
    extends
        DefaultModelClassFactory
{
    private static final long serialVersionUID = -2941319197788700696L;


    @SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
    public Class getMessageClass( String theName, String theVersion, boolean isExplicit )
        throws HL7Exception
    {
        if ( theName.equals( "ORU_R01" ) )
        {
            try
            {
                return Class.forName( "gov.va.med.cds.hapi.extension.message.ORU_R01" );
            }
            catch ( ClassNotFoundException e )
            {
                throw new HL7Exception( e );
            }
        }
        
        if ( theName.equals( "RDE_O11" ) )
        {
            try
            {
                return Class.forName( "gov.va.med.cds.hapi.extension.message.RDE_O11" );
            }
            catch ( ClassNotFoundException e )
            {
                throw new HL7Exception( e );
            }
        }
        
        if ( theName.equals( "RDS_O13" ) )
        {
            try
            {
                return Class.forName( "gov.va.med.cds.hapi.extension.message.RDS_O13" );
            }
            catch ( ClassNotFoundException e )
            {
                throw new HL7Exception( e );
            }
        }

        if ( theName.equals( "SPQ_Q08" ) )
        {
            try
            {
                return Class.forName( "gov.va.med.cds.hapi.extension.message.SPQ_Q08" );
            }
            catch ( ClassNotFoundException e )
            {
                throw new HL7Exception( e );
            }
        }

        if ( theName.equals( "TBR_R08" ) )
        {
            try
            {
                return Class.forName( "gov.va.med.cds.hapi.extension.message.TBR_R08" );
            }
            catch ( ClassNotFoundException e )
            {
                throw new HL7Exception( e );
            }
        }

        if ( theName.equals( "QRY_Q01" ) )
        {
            try
            {
                return Class.forName( "gov.va.med.cds.hapi.extension.message.QRY_Q01" );
            }
            catch ( ClassNotFoundException e )
            {
                throw new HL7Exception( e );
            }
        }

        return super.getMessageClass( theName, theVersion, isExplicit );
    }
}
