

package gov.va.med.repositories.fpds.ejb;


import gov.va.med.cds.audit.persistence.CdsAuditClobStore;
import gov.va.med.cds.client.proxy.NetworkClientProxyInterface;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.hapi.HL7Utility;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.interceptor.Interceptors;
import javax.jms.JMSException;

import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

@Interceptors(SpringBeanAutowiringInterceptor.class)
public class FpdsVistAHl7CreateRequestMdb extends AbstractFpdsVistAHl7CreateRequestMdb   
{
	private static String CLIENT_INITIATION_TIME = "CLIENT_INITIATION_TIME";
	private static String CLIENT_NAME = "CLIENT_NAME";
	private static String PATIENT_AUTHORITY = "PATIENT_AUTHORITY";
	private static String DOMAIN = "DOMAIN";
	private static final String DEFAULT_AUTHORITY = "USVHA";
	   
    public FpdsVistAHl7CreateRequestMdb() {
		
	}
    
    public void ejbCreate(){
    	defaultDomainEnvEntry = (String)safeGetEnvironmentEntry("java:comp/env/defaultDomainType", String.class, "TIUHL7");
	}
     
    @Override
    protected String sendHl7Request( String host, String hl7Message )
    {     
    	Properties properties = new Properties();
        properties.setProperty( NetworkClientProxyInterface.PROP_DNS_NAME, host );
 
        return dnsSocketProxy.sendMessage( hl7Message, properties );                  
    }
       
    @Override
	protected Map<String, String> getMessageProperties(HL7SupportInterface message) throws JMSException {
		
    	String authority = DEFAULT_AUTHORITY;
		//String clientName = DEFAULT_CLIENT_NAME;
		String clientName = message.getSendingApplication();//MSH-3  - closest thing we will have to the client name
					
		Map<String,String> messageProperties = new HashMap<String,String>(8);
        messageProperties.put(REQUEST_ID, message.getMessageControlId());
        messageProperties.put(CLIENT_INITIATION_TIME, message.getMessageDateTime());
        messageProperties.put(CLIENT_NAME, clientName );
        messageProperties.put(PATIENT_FACILITY, message.getReceivingFacilityStation());
        messageProperties.put(PATIENT_AUTHORITY,authority);
        messageProperties.put(RECORD_UPDATE_TIME, message.getMessageDateTime());
    
        messageProperties.put(DOMAIN, defaultDomainEnvEntry);
        
        return messageProperties;
	}
    
    protected CdsAuditClobStore buildAuditClobStore(Map<String,String> messageProperties, String hl7Payload){
    	
    	CdsAuditClobStore auditClobStore = new CdsAuditClobStore();
    	
    	auditClobStore.setFacilityId(messageProperties.get(PATIENT_FACILITY));
    	auditClobStore.setRequestId(messageProperties.get(REQUEST_ID));
    	auditClobStore.setTemplateId(TEMPLATE_ID);
    	auditClobStore.setHl7Clob(hl7Payload);
    	auditClobStore.setMessageDateTime(messageProperties.get(RECORD_UPDATE_TIME));
    	auditClobStore.setMessageType(messageProperties.get(DOMAIN));
    	auditClobStore.setClientIdentifier(messageProperties.get(CLIENT_NAME));
    	auditClobStore.setClientRequestInitiationTime(messageProperties.get(CLIENT_INITIATION_TIME));
    	
    	return auditClobStore;
    }
    
    /**
     * Method must construct a Commit Reject Hl7 Message that resembles those returned by an Hl7 Listener on a
     * VistA site. These rejects will contain FPDS validation and/or other errors that may have occurred in the 
     * attempt to persist/send the Hl7 to VistA
     */
    protected String buildCommitReject(String originalMessageControlId, String rejectMsg, HL7SupportInterface hl7Support ){
    	
    	String commitReject = "UNKNOWN ERROR PROCESSING REQUEST: " + rejectMsg;//default value, should get overwritten below
    	if(hl7Support != null){	
    		commitReject = hl7Support.createHl7WriteAckReject(rejectMsg);	
    	}
    	else{
    		//Hl7 message payload is missing or doesn't parse correctly so we do not have hl7Support to construct the reject, we must build it manually.
        	String messageDate = getCurrentTime();
        	String origMessageContId=originalMessageControlId;
        	String receivingFacility = "HDR_HL7_SERVER";
        	String sendingFacility = "TIU_CLIENT";
        	String receivingApp="TIUHL7";
        	String sendingApp="HDRAPP";
    		String messageControlId = HL7Utility.createMessageControlId();
    		
    		StringBuffer commitRejectBuf = new StringBuffer();
    		commitRejectBuf.append("MSH^~|\\&^"+receivingApp+"^"+receivingFacility+"^"+sendingApp+"^"+sendingFacility+"^"+messageDate+"^^ACK^"+messageControlId+"^T^2.4");
    		commitRejectBuf.append("\r");
    		commitRejectBuf.append("MSA^CR^"+origMessageContId+"^"+rejectMsg);
    		commitReject = commitRejectBuf.toString();   		
    	}
    	
    	return commitReject;
    }
     
    
}


