package gov.va.med.cds.tools.cleanup.errorq;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class ErrorQueueDefaultMessageListenerContainer extends
		DefaultMessageListenerContainer {
	
	final static String JMS_MESSAGE_TIMESTAMP_BEGIN = "jms.message.timestamp.begin";
	final static String JMS_MESSAGE_TIMESTAMP_END = "jms.message.timestamp.end";
	final static String JMS_MESSAGE_TIMESTAMP_TOKEN = "jmsTimestampToken";
	final static String JMS_MESSAGE_SENDING_APP = "jms.message.sendingapp";
	final static int SENDING_APP_LENGTH = "SendingApp".length();
	
	private static Log logger = LogFactory.getLog( ErrorQueueDefaultMessageListenerContainer.class );
	
	public ErrorQueueDefaultMessageListenerContainer(){
		super();
	}
	public void setMessageSelector(String messageSelector){
		
		if( logger.isInfoEnabled()){
			logger.info("===============================================================================================================================");
			logger.info("XML configure Message selector: '" + messageSelector + "'");
			logger.info("===============================================================================================================================");
		}
		
		String strJmsMessageTimestampBegin = System.getProperty(JMS_MESSAGE_TIMESTAMP_BEGIN);
		String strJmsMessageTimestampEnd = System.getProperty(JMS_MESSAGE_TIMESTAMP_END);
		
		String strSendingApp = System.getProperty(JMS_MESSAGE_SENDING_APP);
		Date jmsTimestampBegin = null;
		Date jmsTimestampEnd = null;
		
		
		StringBuilder sb = new StringBuilder(messageSelector);
		if( (strSendingApp == null) || (strSendingApp.length() < SENDING_APP_LENGTH)){
			int start = messageSelector.indexOf('(');
			int end = messageSelector.indexOf(')');
			if( (start != -1) && (end > start)){
				sb.delete(start, (end+1));
			}
			start = sb.indexOf("and");
			sb.delete(start, (start + 3));
			
		}
		
		if( strJmsMessageTimestampBegin != null){
			
			jmsTimestampBegin = ErrorQueueJMSTimestampUtil.parse(strJmsMessageTimestampBegin);
			
		}
		
		if( strJmsMessageTimestampEnd == null){
			
			// End Timestampis not specified in command line, use current time instead
			strJmsMessageTimestampEnd = System.getProperty(ErrorQCleanUp.DEFAULT_JMS_TIMESTAMP_END);
			jmsTimestampEnd = ErrorQueueJMSTimestampUtil.parse(strJmsMessageTimestampEnd);
		}else {
			// if specified end timestamp is later than current time, use current time instead
			
			jmsTimestampEnd = ErrorQueueJMSTimestampUtil.parse(strJmsMessageTimestampEnd);
			String strJmsMessageDefaultTimestampEnd = System.getProperty(ErrorQCleanUp.DEFAULT_JMS_TIMESTAMP_END);
			Date jmsDefaultTimestampEnd = ErrorQueueJMSTimestampUtil.parse(strJmsMessageDefaultTimestampEnd);
			if( (jmsTimestampEnd != null) && (jmsTimestampEnd.getTime() > jmsDefaultTimestampEnd.getTime()) ){
				jmsTimestampEnd = jmsDefaultTimestampEnd;
			}
			
			
		}
					
		
		String str = "";
		
		if( jmsTimestampBegin != null){
			long beginTime = jmsTimestampBegin.getTime();
			str = " JMSTimestamp > " + beginTime;
		}
		long endTime = jmsTimestampEnd.getTime();
			 
		if( str.length() > 0){
				str = str + " AND " + "JMSTimestamp < " + endTime; 
		}else{
				str = "JMSTimestamp < " + endTime; 
		}
		
		int tokenBegin = sb.indexOf(JMS_MESSAGE_TIMESTAMP_TOKEN);
		int tokenEnd = tokenBegin + JMS_MESSAGE_TIMESTAMP_TOKEN.length();
		
		sb.replace(tokenBegin, tokenEnd, str);
			
		if( logger.isInfoEnabled()){
			logger.info("=======================================================================================================================================================");
			logger.info("************** Modified Filter message: '" + sb.toString() + "' *******************");
			logger.info("=======================================================================================================================================================");
		}
		
		super.setMessageSelector(sb.toString());
				
	}

}

