

package gov.va.med.cds.response.util;


import gov.va.med.cds.exception.ResponseException;
import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.util.StreamUtil;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:gov/va/med/cds/response/util/responseErrorSectionExtractorContext.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class ResponseErrorSectionExtractorTest
{
    static String icReadResponseWithErrorSection;
    static String icReadResponseWithNoErrorSection;

    private ResponseErrorSectionExtractor responseErrorSectionExtractor;


    @javax.annotation.Resource
    public void setResponseErrorSectionExtractor( ResponseErrorSectionExtractor responseErrorSectionExtractor )
    {
        this.responseErrorSectionExtractor = responseErrorSectionExtractor;
    }


    @BeforeTestsOnce
    @Suite( groups = { "checkintest" }, order = 1 )
    public static void beforeResponseErrorSectionExtractorTestsSetup( )
        throws Exception
    {
        ResourceLoader resourceLoader = new DefaultResourceLoader();

        Resource resource = resourceLoader.getResource( "classpath:gov/va/med/cds/response/util/AllergyRead400IntoleranceCondition.xml" );
        icReadResponseWithErrorSection = StreamUtil.resourceToString( resource );

        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/response/util/AllergyRead400IntoleranceConditionWithNoErrors.xml" );
        icReadResponseWithNoErrorSection = StreamUtil.resourceToString( resource );
    }


    @Test
    @Suite( groups = { "checkintest" }, order = 2 )
    public void testGetErrorSection( )
    {
        String errorSection = responseErrorSectionExtractor.getErrorSection( icReadResponseWithErrorSection );
        Assert.assertTrue( errorSection.contains( "ErrorSevirity" ) );
    }


    @Test
    @Suite( groups = { "checkintest" }, order = 3 )
    public void testGetErrorSectionWithNoErrors( )
    {
        String errorSection = responseErrorSectionExtractor.getErrorSection( icReadResponseWithNoErrorSection );
        Assert.assertFalse( errorSection.contains( "ErrorSevirity" ) );
        Assert.assertTrue( errorSection.length() == 0 );
    }


    @Test
    @Suite( groups = { "checkintest" }, order = 4 )
    public void testCheckForErrorsInResponseWithNoErrors( )
        throws Exception
    {
        responseErrorSectionExtractor.checkForErrorsInResponse( icReadResponseWithNoErrorSection );
    }


    @Test( expected = ResponseException.class )
    @Suite( groups = { "checkintest" }, order = 5 )
    public void testCheckForErrorsInResponseWithErrors( )
        throws Exception
    {
        responseErrorSectionExtractor.checkForErrorsInResponse( icReadResponseWithErrorSection );
    }


    @Test
    @Suite( groups = { "checkintest" }, order = 6 )
    public void testGetDocument( )
    {
        responseErrorSectionExtractor.getDocument( "<invalidResoponse>" );
    }
}
