

package gov.va.med.cds.monitor.util;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.monitor.CdsReadMethodMetrics;

import org.junit.Test;


import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class CdsReadMethodMetricsTest
{
    CdsReadMethodMetrics cdsReadMethodMetrics;

    private long methodCount = 0;
    private long methodElapsedTime = 0;
    private long minElapsedTime = Long.MAX_VALUE;
    private long maxElapsedTime = Long.MIN_VALUE;
    private double averageElapsedTime = 0.0d;
    private double transactionsPerSecond = 0.0d;


    @Test
    @Suite( groups = "checkintest" )
    public void testEnableMetrics( )
    {
        cdsReadMethodMetrics = new CdsReadMethodMetrics();
        cdsReadMethodMetrics.enableMetrics();

        assertTrue( cdsReadMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, cdsReadMethodMetrics.getCdsReadTransactions() );
        assertEquals( methodElapsedTime, cdsReadMethodMetrics.getCdsReadElapsedTime() );
        assertEquals( transactionsPerSecond, cdsReadMethodMetrics.getCdsReadTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, cdsReadMethodMetrics.getCdsReadAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, cdsReadMethodMetrics.getCdsReadMaxElapsedTime() );
        assertEquals( minElapsedTime, cdsReadMethodMetrics.getCdsReadMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetSingleMethodElapsedTime( )
    {
        long elapsedTime = 100L;
        long methodCount = 1;
        long methodElapsedTime = elapsedTime;
        long minElapsedTime = elapsedTime;
        long maxElapsedTime = elapsedTime;
        double averageElapsedTime = elapsedTime;
        double transactionsPerSecond = 10.0d;

        cdsReadMethodMetrics = new CdsReadMethodMetrics();
        cdsReadMethodMetrics.enableMetrics();
        cdsReadMethodMetrics.setSingleMethodElapsedTime( elapsedTime );

        assertTrue( cdsReadMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, cdsReadMethodMetrics.getCdsReadTransactions() );
        assertEquals( methodElapsedTime, cdsReadMethodMetrics.getCdsReadElapsedTime() );
        assertEquals( transactionsPerSecond, cdsReadMethodMetrics.getCdsReadTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, cdsReadMethodMetrics.getCdsReadAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, cdsReadMethodMetrics.getCdsReadMaxElapsedTime() );
        assertEquals( minElapsedTime, cdsReadMethodMetrics.getCdsReadMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisableMetrics( )
    {
        cdsReadMethodMetrics = new CdsReadMethodMetrics();
        cdsReadMethodMetrics.enableMetrics();

        assertTrue( cdsReadMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, cdsReadMethodMetrics.getCdsReadTransactions() );
        assertEquals( methodElapsedTime, cdsReadMethodMetrics.getCdsReadElapsedTime() );
        assertEquals( transactionsPerSecond, cdsReadMethodMetrics.getCdsReadTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, cdsReadMethodMetrics.getCdsReadAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, cdsReadMethodMetrics.getCdsReadMaxElapsedTime() );
        assertEquals( minElapsedTime, cdsReadMethodMetrics.getCdsReadMinElapsedTime() );

        cdsReadMethodMetrics.disableMetrics();
        assertFalse( cdsReadMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, cdsReadMethodMetrics.getCdsReadTransactions() );
        assertEquals( methodElapsedTime, cdsReadMethodMetrics.getCdsReadElapsedTime() );
        assertEquals( transactionsPerSecond, cdsReadMethodMetrics.getCdsReadTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, cdsReadMethodMetrics.getCdsReadAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, cdsReadMethodMetrics.getCdsReadMaxElapsedTime() );
        assertEquals( minElapsedTime, cdsReadMethodMetrics.getCdsReadMinElapsedTime() );
    }
}
