

package gov.va.med.cds.monitor.util;


import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.assertEquals;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.monitor.CdmToVdmMapMethodMetrics;

import org.junit.Test;


import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class CdmToVdmMapMethodMetricsTest
{
    CdmToVdmMapMethodMetrics cdmToVdmMapMethodMetrics;

    private long methodCount = 0;
    private long methodElapsedTime = 0;
    private long minElapsedTime = Long.MAX_VALUE;
    private long maxElapsedTime = Long.MIN_VALUE;
    private double averageElapsedTime = 0.0d;
    private double transactionsPerSecond = 0.0d;


    @Test
    @Suite( groups = "checkintest" )
    public void testEnableMetrics( )
    {
        cdmToVdmMapMethodMetrics = new CdmToVdmMapMethodMetrics();
        cdmToVdmMapMethodMetrics.enableMetrics();

        assertTrue( cdmToVdmMapMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, cdmToVdmMapMethodMetrics.getCdmToVdmMapTransactions() );
        assertEquals( methodElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapElapsedTime() );
        assertEquals( transactionsPerSecond, cdmToVdmMapMethodMetrics.getCdmToVdmMapTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapMaxElapsedTime() );
        assertEquals( minElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapMinElapsedTime() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSetSingleMethodElapsedTime( )
    {
        long elapsedTime = 100L;
        long methodCount = 1;
        long methodElapsedTime = elapsedTime;
        long minElapsedTime = elapsedTime;
        long maxElapsedTime = elapsedTime;
        double averageElapsedTime = elapsedTime;
        double transactionsPerSecond = 10.0d;

        cdmToVdmMapMethodMetrics = new CdmToVdmMapMethodMetrics();
        cdmToVdmMapMethodMetrics.enableMetrics();
        cdmToVdmMapMethodMetrics.setSingleMethodElapsedTime( elapsedTime );

        assertTrue( cdmToVdmMapMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, cdmToVdmMapMethodMetrics.getCdmToVdmMapTransactions() );
        assertEquals( methodElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapElapsedTime() );
        assertEquals( transactionsPerSecond, cdmToVdmMapMethodMetrics.getCdmToVdmMapTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapMaxElapsedTime() );
        assertEquals( minElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapMinElapsedTime(), 0.0 );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisableMetrics( )
    {
        cdmToVdmMapMethodMetrics = new CdmToVdmMapMethodMetrics();
        cdmToVdmMapMethodMetrics.enableMetrics();

        assertTrue( cdmToVdmMapMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, cdmToVdmMapMethodMetrics.getCdmToVdmMapTransactions() );
        assertEquals( methodElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapElapsedTime() );
        assertEquals( transactionsPerSecond, cdmToVdmMapMethodMetrics.getCdmToVdmMapTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapMaxElapsedTime() );
        assertEquals( minElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapMinElapsedTime() );

        cdmToVdmMapMethodMetrics.disableMetrics();
        assertFalse( cdmToVdmMapMethodMetrics.isCollectionEnabled() );
        assertEquals( methodCount, cdmToVdmMapMethodMetrics.getCdmToVdmMapTransactions() );
        assertEquals( methodElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapElapsedTime() );
        assertEquals( transactionsPerSecond, cdmToVdmMapMethodMetrics.getCdmToVdmMapTransactionsPerSecond(), 0.0 );
        assertEquals( averageElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapAverageElapsedTime(), 0.0 );
        assertEquals( maxElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapMaxElapsedTime() );
        assertEquals( minElapsedTime, cdmToVdmMapMethodMetrics.getCdmToVdmMapMinElapsedTime() );
    }
}
