/**
 * 
 */


package gov.va.med.cds.clinicaldata.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;


/**
 * @author DNS   egberb
 *
 */
@RunWith( SuiteAwareRunner.class )
public class CdsResponse1ClinicalDataResponseTest
{

    @Test( expected = IllegalArgumentException.class )
    @Suite( groups = "checkintest" )
    public void testBuildRecordIdentifierElementEmptyDocument( )
    {
        String recordId = "theRecordId";
        Element clinicalDataElementMock = EasyMock.createMock( Element.class );

        EasyMock.expect( clinicalDataElementMock.element( "documentIdentifier" ) ).andReturn( null );
        EasyMock.replay( clinicalDataElementMock );

        CdsResponse1ClinicalDataResponse cdResponse = new CdsResponse1ClinicalDataResponse( "patients/patient", "clinicalData", "errorResponse" );
        cdResponse.buildRecordIdentifierElement( recordId, clinicalDataElementMock );
        fail( "Should never have made it this far with an empty document." );

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testBuildRecordIdentifierValid( )
    {
        String recordId = "theRecordId";
        Element clinicalDataElementMock = EasyMock.createMock( Element.class );
        Element documentIdentifierElementMock = EasyMock.createMock( Element.class );
        Element approvedFlagMock = EasyMock.createMock( Element.class );

        EasyMock.expect( clinicalDataElementMock.element( "documentIdentifier" ) ).andReturn( documentIdentifierElementMock );
        EasyMock.expect( documentIdentifierElementMock.clone() ).andReturn( DocumentHelper.createElement( "documentIdentifier" ) );
        EasyMock.expect( clinicalDataElementMock.element("approvedFlag")).andReturn( approvedFlagMock );
        EasyMock.expect(approvedFlagMock.getText()).andReturn( "PENDING" );
        EasyMock.replay( clinicalDataElementMock, documentIdentifierElementMock, approvedFlagMock );

        CdsResponse1ClinicalDataResponse cdResponse = new CdsResponse1ClinicalDataResponse( "patients/patient", "clinicalData", "errorResponse" );
        cdResponse.setStatusElementName("approvedFlag");
        Element recordIdentifierElement = cdResponse.buildRecordIdentifierElement( recordId, clinicalDataElementMock );
        assertNotNull( recordIdentifierElement );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testBuildDocumentIdentifierErrorSection( )
    {
        String templateId = "DBQCreate1";
        String requestId = "SomeRequestId";
        String errorText = "Some existing error.";
        String documentId = "ID00012032489";

        // Create Mocks
        Document writeResultDocumentMock = EasyMock.createMock( Document.class );
        Document clinicalRequestDocumentMock = EasyMock.createMock( Document.class );
        Node displayMessageElementMock = EasyMock.createMock( Node.class );
        Map<String, Set<DomainEntryPoint>> templateIdToDomainEntryPointListMap = new HashMap<String, Set<DomainEntryPoint>>();
        Set<DomainEntryPoint> domainEntryPointSet = new HashSet<DomainEntryPoint>();
        domainEntryPointSet.add( DomainEntryPoint.QuestionnaireResult );
        templateIdToDomainEntryPointListMap.put( templateId, domainEntryPointSet );
        Element documentRootMock = EasyMock.createMock( Element.class );
        Element patientElementMock = EasyMock.createMock( Element.class );
        List<Element> clinicalRecordsList = new ArrayList<Element>();
        Element clinicalRecordElementMock = EasyMock.createMock( Element.class );
        clinicalRecordsList.add( clinicalRecordElementMock );
        Node documentIdentifierNodeMock = EasyMock.createMock( Node.class );
        Element wrapperPatientElementMock = EasyMock.createMock( Element.class );

        // Set Expectations
        EasyMock.expect( writeResultDocumentMock.selectSingleNode( "//displayMessage" ) ).andReturn( displayMessageElementMock );
        EasyMock.expect( displayMessageElementMock.getText() ).andReturn( "Some existing error." );
        EasyMock.expect( clinicalRequestDocumentMock.getRootElement() ).andReturn( documentRootMock );
        EasyMock.expect( documentRootMock.element( "patient" ) ).andReturn( patientElementMock );
        EasyMock.expect( patientElementMock.element( DomainEntryPoint.QuestionnaireResult.getEntityName() ) ).andReturn( wrapperPatientElementMock );
        EasyMock.expect( wrapperPatientElementMock.elements( "questionnaireResult" ) ).andReturn( clinicalRecordsList );
        EasyMock.expect( clinicalRecordElementMock.selectSingleNode( "//documentIdentifier/identity" ) ).andReturn( documentIdentifierNodeMock );
        EasyMock.expect( documentIdentifierNodeMock.getText() ).andReturn( documentId );
        displayMessageElementMock.setText( errorText + " Could not process document(s): [" + documentId + "]" );
        EasyMock.expectLastCall();

        // Make mock object available
        EasyMock.replay( writeResultDocumentMock, displayMessageElementMock, clinicalRequestDocumentMock, documentRootMock, patientElementMock,
                        wrapperPatientElementMock, clinicalRecordElementMock, documentIdentifierNodeMock );

        CdsResponse1ClinicalDataResponse cdResponse = new CdsResponse1ClinicalDataResponse( "patients/patient", "clinicalData", "errorResponse" );
        cdResponse.setTemplateIdToDomainEntryPointListMap( templateIdToDomainEntryPointListMap );
        cdResponse.buildErrorResponse( templateId, requestId, writeResultDocumentMock, clinicalRequestDocumentMock );
        EasyMock.verify( displayMessageElementMock );
    }

}
