

package gov.va.med.cds.audit;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.util.StreamUtil;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.util.Date;


/**
 * @author DNS   egberb
 *
 */
@RunWith( SuiteAwareRunner.class )
public class LegacyReadAuditLogTest
{

    private static LegacyReadAuditLog auditLog = new LegacyReadAuditLog();


    @Test
    @Suite( groups = { "checkintest" } )
    public void testAuditLogIdProperty( )
    {
        // no setter for this value.
        assertNull( auditLog.getAuditLogId() );
    }


    @Test
    @Suite( order = 1, groups = { "checkintest" } )
    public void testStartTimeProperty( )
    {
        auditLog.setStartTime( 12335L );
        assertEquals( auditLog.getStartTime(), 12335L );
    }


    @Test
    @Suite( order = 2, groups = { "checkintest" } )
    public void testEndTimeProperty( )
    {
        auditLog.setEndTime( 12345L );
        assertEquals( auditLog.getEndTime(), 12345L );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testFacilityProperty( )
    {
        auditLog.setFacility( "FACILITY" );
        assertEquals( auditLog.getFacility(), "FACILITY" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testIsoLocalTimeProperty( )
    {
        assertNotNull( auditLog.getIsoLocalTime() );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLocalTimeProperty( )
    {
        auditLog.setLocalTime( new Date( 12345L ) );
        assertEquals( auditLog.getLocalTime().getTime(), 12345L );
    }


    @Test
    @Suite( groups = { "checkintest" }, order = 3, dependsOnMethods = { "testStartTimeProperty", "testEndTimeProperty" } )
    public void testMillisecondsDerivedValue( )
    {
        assertEquals( auditLog.getMilliseconds(), 10L );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testFilterId( )
    {
        auditLog.setFilterId( "FILTER_ID" );
        assertEquals( auditLog.getFilterId(), "FILTER_ID" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRequestProperty( ) throws IOException
    {
    	
        Resource filterResource = new ClassPathResource( "gov/va/med/cds/audit/vitalsFilter.xml");
        String filter = StreamUtil.resourceToString(filterResource);

        auditLog.setFilterRequest( filter );
        assertEquals( auditLog.getFilterRequest(), filter);
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRequestIdProperty( )
    {
        auditLog.setRequestId( "REQUEST_ID" );
        assertEquals( auditLog.getRequestId(), "REQUEST_ID" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testResponseProperty( )
    {
        auditLog.setResponse( "RESPONSE1\rRESPONSE2\rRESPONSE3" );
        assertEquals( auditLog.getResponse(), "RESPONSE1\rRESPONSE2\rRESPONSE3" );

        assertEquals( auditLog.getResponseSize(), 29 );
        assertEquals( auditLog.getResponseLength(), 3 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testSendingApplicationProperty( )
    {
        auditLog.setSendingApplication( "SENDING_APPLICATION" );
        assertEquals( auditLog.getSendingApplication(), "SENDING_APPLICATION" );
    }
    
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testClientIdentifierProperty( )
    {
        auditLog.setClientId( "CLIENT_ID" );
        assertEquals( auditLog.getClientId(), "CLIENT_ID" );
    }
    
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testClientRequestInitiationTimeProperty( )
    {
        auditLog.setClientRequestInitiationTime( "2001-12-17T09:30:47.0Z" );
        assertEquals( auditLog.getClientRequestInitiationTime(), "2001-12-17T09:30:47.0Z" );
    }


    @Test
    @Suite( groups = { "checkintest" }, order = 4 , dependsOnMethods = { "testEndTimeProperty", "testFacilityProperty", "testIsoLocalTimeProperty",
                    "testLocalTimeProperty", "testFilterId", "testRequestIdProperty", "testRequestProperty", "testResponseProperty",
                    "testSendingApplicationProperty", "testStartTimeProperty" })
    public void testGetDebugInfo( ) throws IOException
    {
    	Resource filterResource = new ClassPathResource( "gov/va/med/cds/audit/vitalsFilter.xml");
        String filter = StreamUtil.resourceToString(filterResource);

    	
        StringBuilder sbDebugInfo = new StringBuilder();
        sbDebugInfo.append( "Server CDS v3.x ==> Audit detail: \n" );
        sbDebugInfo.append( "\tdomain => CDS v3.x\n" );
        sbDebugInfo.append( "\tstart_milliseconds => 12335\n" );
        sbDebugInfo.append( "\tmilliseconds => 10\n" );
        sbDebugInfo.append( "\tISO_localtime => " ).append( auditLog.getIsoLocalTime() ).append( "\n" );
        sbDebugInfo.append( "\tlog_information => \n" );
        sbDebugInfo.append( "\t\tstartTime -> 12335\n" );
        sbDebugInfo.append( "\t\tsendingApplication -> SENDING_APPLICATION\n" );
        sbDebugInfo.append( "\t\toriginalMessageControlId -> REQUEST_ID\n" );
        sbDebugInfo.append( "\t\trequesterString -> \n" );
        sbDebugInfo.append( "\t\trequestMsg -> " ).append(filter).append( "\n" );
        sbDebugInfo.append( "\t\treceivingApplication -> CDS v3.x\n" );
        sbDebugInfo.append( "\t\tcompletionTime -> " ).append( auditLog.getEndTime() );
     
        assertEquals( auditLog.getDebugInfo(), sbDebugInfo.toString() );
    }


    @Test
    @Suite( groups = { "checkintest" }, order = 5, dependsOnMethods = { "testGetDebugInfo" } )
    public void testSetDebugInfo( ) throws IOException
    {
    	Resource resource = new ClassPathResource( "gov/va/med/cds/audit/vhimResponse.xml" );
    	Resource filterResource = new ClassPathResource( "gov/va/med/cds/audit/vitalsFilter.xml");
    	  String response = StreamUtil.resourceToString( resource );
        String filter = StreamUtil.resourceToString(filterResource);

 
        StringBuilder sbDebugInfo = new StringBuilder();
        sbDebugInfo.append( "Server CDS v3.x - Message Mediator ==> Audit detail: \n" );
        sbDebugInfo.append(  "\tdomain => CDS v3.x\n" );
        sbDebugInfo.append( "\tstart_milliseconds => 12335\n" );
        sbDebugInfo.append( "\tmilliseconds => 10\n" );
        sbDebugInfo.append( "\tISO_localtime => 20081021083759.999-0700\n" );
        sbDebugInfo.append( "\tlog_point => \n" );
        sbDebugInfo.append( "\tlog_information => \n" );
        sbDebugInfo.append( "\t\tstartTime -> 12335\n" );
        sbDebugInfo.append( "\t\tsendingApplication -> SENDING_APPLICATION\n" );
        sbDebugInfo.append( "\t\toriginalMessageControlId -> REQUEST_ID\n" );
        sbDebugInfo.append( "\t\trequesterString -> \n" );
        sbDebugInfo.append( "\t\trequestMsg -> " ).append(filter).append( "\n" );
        sbDebugInfo.append( "\t\trecievingApplication -> CDS v3.x\n" );
        sbDebugInfo.append( "\t\tcompletionTime -> " ).append( auditLog.getEndTime() );

        VhimReadResponseAuditLog auditLog = new VhimReadResponseAuditLog();
        
        auditLog.setEndTime( 12345L );
        auditLog.setLocalTime( new Date( 55555L ) );
        auditLog.setIsoLocalTime( "20081021125959.999-600" );
        auditLog.setFilterRequest(filter);
        auditLog.setRequestId( "REQUEST_ID" );
        auditLog.setResponse( response );
        auditLog.setSendingApplication( "SENDING_APPLICATION" );
        auditLog.setStartTime( 12335L );
        auditLog.setClientId( "CLIENT_ID" );
        auditLog.setClientRequestInitiationTime( "2001-12-17T09:30:47.0Z" );


        assertEquals( auditLog.getDomainName(), "CDS v3.x" );
        assertEquals( auditLog.getStartTime(), 12335L );
        assertEquals( auditLog.getMilliseconds(), 10L );
        assertEquals( auditLog.getIsoLocalTime(), "20081021125959.999-600" );
        assertEquals( auditLog.getSendingApplication(), "SENDING_APPLICATION" );
        assertEquals( auditLog.getRequestId(), "REQUEST_ID" );
        assertEquals( auditLog.getFilterRequest(), filter );
        assertEquals( auditLog.getEndTime(), 12345L );
        
        auditLog.setClientId( "CLIENT_ID" );
        auditLog.setClientRequestInitiationTime( "2001-12-17T09:30:47.0Z" );
    }

}
