/**
 * 
 */


package gov.va.med.cds.clinicaldata;


import java.util.List;

import org.dom4j.Element;


/**
 * @author DNS   ecclej
 * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
 */
public enum DomainEntryPoint
{
    ADLSurveyResponse( "ADLSurveyResponse", "SURVEY", "adlSurveyResponse", gov.va.med.cds.template.generated.surveys.ADLSurveyResponse.class  ), 
    PSSurveyResponse( "PSSurveyResponse", "SURVEY", "psSurveyResponse", gov.va.med.cds.template.generated.surveys.PSSurveyResponse.class ), 
    DMPSurveyResponse( "DMPSurveyResponse", "SURVEY", "dmpSurveyResponse", gov.va.med.cds.template.generated.surveys.DMPSurveyResponse.class ), 
    CensusSurveyResponse( "CensusSurveyResponse", "SURVEY", "censusSurveyResponse", gov.va.med.cds.template.generated.clinicaldata.Patients.class),
    VitalSignObservationEvent( "VitalSignObservationEvent", "VITAL", "vitalSignObservationEvents", gov.va.med.cds.template.generated.vitalsigns.VitalSignObservationEvent.class), 
    IntoleranceCondition( "IntoleranceCondition", "ALLERGY", "intoleranceConditions", gov.va.med.cds.template.generated.allergies.IntoleranceCondition.class), 
    AllergyAssessment( "AllergyAssessment", "ALLERGY", "allergyAssessments", gov.va.med.cds.template.generated.allergies.AllergyAssessment.class ), 
    OutpatientMedicationPromise( "OutpatientMedicationPromise", "PHARMACY", "outpatientMedicationPromises", gov.va.med.cds.template.generated.pharmacy.OutpatientMedicationPromise.class), 
    LabTestPromise( "LabTestPromise", "LAB", "labTestPromises", gov.va.med.cds.template.generated.lab.LabTestPromise.class), 
    NonVaMedicationEvent( "NonVaMedicationEvent", "NONVAMED", "nonVaMedicationEvent" ), 
    ClinicalDocumentEvent( "ClinicalDocumentEvent", "TIU", "clinicalDocumentEvents" ), 
    ImmunizationEvent( "ImmunizationEvent", "IMMUNIZATION", "immunizationEvents" ), 
    SkinTestProcedure( "SkinTestProcedure", "SKINTEST", "skinTestProcedures" ), 
    HealthConcern( "HealthConcern", "PROBLEMLIST", "healthConcern" ), 
    ExamRequest2507( "ExamRequest2507", "EXAMREQUEST", "examRequests" ), 
    Exam2507( "Exam2507", "EXAM", "exams" ), 
    Appointment( "Appointment", "Appointment", "appointments" ),
    AppointmentLetter( "AppointmentLetter", "AppointmentLetter", "appointmentLetters" ), 
    PatientDataAccessedEvent( "PatientDataAccessedEvent", "PatientDataAccessedEvent", "patientDataAccessedEvents" ),
    Demographic( "Demographic", "Demographic", "demographics" ), 
    ReleaseOfInformation( "ReleaseOfInformation", "ReleaseOfInformation", "releasesOfInformation" ),
    ClinicalReminder( "ClinicalReminder", "ClinicalReminder", "clinicalReminders" ), 
    PatientAlert("PatientAlert", "PatientAlert", "patientAlerts"),
    PatientEnteredVitalSign( "PatientEnteredVitalSign", "VITAL", "patientEnteredVitalSigns", "patientEnteredVitalSign" ), 
    PatientEnteredExerciseJournalEntry( "PatientEnteredExerciseJournalEntry", "EXCERCISEJOURNAL", "patientJournalEntries", "patientEnteredExerciseJournalEntry" ), 
    PatientEnteredDietJournalEntry( "PatientEnteredDietJournalEntry", "DIETJOURNAL", "patientJournalEntries", "patientEnteredDietJournalEntry" ), 
    PatientEnteredContactLogJournalEntry( "PatientEnteredContactLogJournalEntry", "CONTACTLOGJOURNAL", "patientJournalEntries", "patientEnteredContactLogJournalEntry" ), 
    PatientEnteredDailyEventJournalEntry( "PatientEnteredDailyEventJournalEntry", "DAILYEVENTJOURNAL", "patientJournalEntries", "patientEnteredDailyEventJournalEntry" ), 
    PatientEnteredMoodJournalEntry( "PatientEnteredMoodJournalEntry", "MOODJOURNAL", "patientJournalEntries", "patientEnteredMoodJournalEntry" ), 
    CalendarEvent( "CalendarEvent", "CALENDAREVENT", "calendarEvents", "calendarEvent" ), 
    QuestionnaireResult( "QuestionnaireResult", "QUESTIONNAIRERESULT", "questionnaireResults", "questionnaireResult" ),
    GoalTracking("GoalTracking", "GOALTRACKING", "goalsTracking","goalTracking"),
    SkillTracking("SkillTracking","SKILLTRACKING", "skillsTracking", "skillTracking"),
    PainEvent("PainEvent","PAINEVENT","painEvents","painEvent"),
    PainReassessment("PainReassessment","PAINREASSESMENT","painReassessments","painReassessment"),
    PainAssessment("PainAssessment", "PAINASSESSMENT","painAssessments", "painAssessment"),
    AssessmentDocument("AssessmentDocument","ASSESSMENTDOCUMENT","assessmentDocuments","assessmentDocument"),
    SmartFormDocument( "SmartFormDocument", "SMARTFORMDOCUMENT", "smartFormDocuments", "smartFormDocument" ),
    GenericObservation( "GenericObservation", "GENERICOBSERVATION", "genericObservations", "genericObservation"),
    PatientGeneratedDataEvent( "PatientGeneratedDataEvent", "PGD", "patientGeneratedDataEvents", "patientGeneratedDataEvent", gov.va.med.cds.template.generated.pgd.PatientGeneratedDataEvent.class),
    GenericHl7DataEvent( "GenericHl7DataEvent", "HL7", "genericHl7DataEvents", "genericHl7DataEvent", gov.va.med.cds.template.generated.generichl7.GenericHl7DataEvent.class),
	VistaUser( "VistaUser", "VISTAUSER", "vistaUsers", "vistaUser" ); 
	    
    private String name;
    private String domain;
    private String entityName;
    private String clinicalDataElement;
    private Class<?> templateUnmarshalClass;

    DomainEntryPoint( String aName, String aDomain, String entityName )
    {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
    }


    DomainEntryPoint( String aName, String aDomain, String entityName, String clinicalDataElement )
    {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
        this.clinicalDataElement = clinicalDataElement;
    }
    
    DomainEntryPoint( String aName, String aDomain, String entityName, Class<?> templateUnmarshalClass )
    {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
        this.setTemplateUnmarshalClass(templateUnmarshalClass);
    }
    
    DomainEntryPoint( String aName, String aDomain, String entityName, String clinicalDataElement, Class<?> templateUnmarshalClass )
    {
        this.name = aName;
        this.domain = aDomain;
        this.entityName = entityName;
        this.clinicalDataElement = clinicalDataElement;
        this.setTemplateUnmarshalClass(templateUnmarshalClass);
    }


    public String getName( )
    {
        return name;
    }


    public void setName( String aName )
    {
        name = aName;
    }


    public String getDomain( )
    {
        return domain;
    }


    public void setDomain( String domain )
    {
        this.domain = domain;
    }


    public String getEntityName( )
    {
        return entityName;
    }


    public void setEntityName( String entityName )
    {
        this.entityName = entityName;
    }


    public String getClinicalDataElement( )
    {
        return clinicalDataElement;
    }


    public void setClinicalDataElement( String clinicalDataElement )
    {
        this.clinicalDataElement = clinicalDataElement;
    }


    @SuppressWarnings( "unchecked" )
    public List<Element> getClinicalRecords( Element rootElement )
    {
        List<Element> clinicalRecords = null;

        if ( this.clinicalDataElement != null )
        {
            // CDS 3.x creates
            Element wrapperElement = rootElement.element( this.entityName );
            clinicalRecords = ( wrapperElement != null ) ? wrapperElement.elements( this.clinicalDataElement ) : null;
        }
        else
        {
            // CDS 2.x create templates with only plural clinicalDataElement
            clinicalRecords = rootElement.elements( this.entityName );
        }

        return clinicalRecords;
    }

    public Class<?> getTemplateUnmarshalClass() {
		return templateUnmarshalClass;
	}


	public void setTemplateUnmarshalClass(Class<?> templateUnmarshalClass) {
		this.templateUnmarshalClass = templateUnmarshalClass;
	}

	public static final String DOMAIN_ENTRY_POINT_PROPERTY_NAME = "DomainEntryPoints";
}
