

package gov.va.med.cds.client.functional.mbean;


import static java.lang.System.out;
import gov.va.med.cds.monitor.util.MBeanConnection;

import java.util.LinkedList;
import java.util.List;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import org.junit.Assert;


public class CustomMBeanUtil
{
    private List<ReponseValidatorMBeanInfoInterface> alphaNodes = new LinkedList<ReponseValidatorMBeanInfoInterface>();
    private MBeanConnection mBeanConnection = new MBeanConnection();


    public void readMBeanAttributes( )
    {
        String hostName;
        String portString;
        String userName;
        String password;
        String serviceName;
        String updateOperationName;
        String readOperationName;
        String operationAttriuteType;
        boolean validationFlag;

        MBeanServerConnection connection;

        try
        {
            for ( ReponseValidatorMBeanInfoInterface node : alphaNodes )
            {
                hostName = node.getHostName();
                portString = node.getPort();
                userName = node.getPrincipal();
                password = node.getCredentials();
                serviceName = node.getBeanKeyName();
                updateOperationName = node.getUpdateOperationName();
                readOperationName = node.getReadOperationName();
                validationFlag = node.isValidationFlag();
                operationAttriuteType = node.getOperationAttriuteType();

                out.println( hostName );
                out.println( portString );
                out.println( userName );
                out.println( password );
                out.println( serviceName );
                out.println( updateOperationName );
                out.println( readOperationName );
                out.println( validationFlag );
                out.println( operationAttriuteType );

                mBeanConnection.initConnection( hostName, portString, userName, password, serviceName );

                connection = mBeanConnection.getConnection();
                ObjectName objectName = mBeanConnection.getService();

                // set the flag as 'true'
                connection.invoke( objectName, node.getUpdateOperationName(), new Object[] { node.isValidationFlag() }, new String[] { node
                                .getOperationAttriuteType() } );
                String validateReadResponseXML = connection.invoke( objectName, node.getReadOperationName(), null, null ).toString();
                out.println( "validateReadResponseXML : " + validateReadResponseXML );
                Assert.assertEquals( new java.lang.Boolean( validateReadResponseXML ).booleanValue(), node.isValidationFlag() );

                mBeanConnection.closeConnection();
            }

        }
        catch ( Exception e )
        {
            e.printStackTrace();
        }
    }


    public void setAlphaNodes( List<ReponseValidatorMBeanInfoInterface> alphaNodes )
    {
        this.alphaNodes = alphaNodes;
    }
}
