

package gov.va.med.cds.util;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.io.File;


@RunWith( SuiteAwareRunner.class )
public class SearchPathGeneratorTest
{
    private static final String EXPECTED_SEARCH_PATH = "../core/main/templatecache/**/*.jar";
    private static final Object EXPECTED_CONSTRUCTED_SEARCH_PATH = "file:DNS     " + File.separatorChar + "servers" + File.separatorChar
                    + "DNS     .admin" + File.separatorChar + "**" + File.separatorChar + "*.jar";


    @Test
    @Suite( groups = { "checkintest" } )
    public void testSimpleStringSearchPathGenerator( )
    {
        SimpleStringSearchPathGenerator generator = new SimpleStringSearchPathGenerator();
        generator.setSearchPath( EXPECTED_SEARCH_PATH );
        assertEquals( generator.getSearchPath(), EXPECTED_SEARCH_PATH );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testConstructedSearchPathGenerator( )
    {
        String userdir = System.getProperty( "user.dir" );
        String weblogicName = System.getProperty( "weblogic.Name" );

        // System property setup code
        System.setProperty( "user.dir", "DNS     " );
        System.setProperty( "weblogic.Name", "DNS     .admin" );

        ConstructedSearchPathGenerator generator = new ConstructedSearchPathGenerator();
        generator.setFirstSystemPropertyName( "user.dir" );
        generator.setFirstFilePathPiece( "servers" );
        generator.setSecondSystemPropertyName( "weblogic.Name" );
        generator.setSecondFilePathPiece( "**" + File.separatorChar + "*.jar" );

        try
        {
            assertEquals( EXPECTED_CONSTRUCTED_SEARCH_PATH, generator.getSearchPath() );
        }
        finally
        {
            if ( userdir != null )
                System.setProperty( "user.dir", userdir );
            if ( weblogicName != null )
                System.setProperty( "weblogic.Name", weblogicName );
        }
    }
}
