/**
 * 
 */
package gov.va.med.cds.rules;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.HashSet;
import java.util.Set;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * @author DNS   egberb
 *
 */
@RunWith( SuiteAwareRunner.class )
public class DomainEntryPointRuleTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    public void testDomainEntryPointEvaluateTrue()
    {
        DomainEntryPointRule rule = new DomainEntryPointRule();
        rule.setEntryPoint( "IntoleranceCondition" );
        Assert.assertTrue( rule.evaluate( DomainEntryPoint.IntoleranceCondition ) );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testNullDomainEntryPointEvaluateTrue()
    {
        DomainEntryPointRule rule = new DomainEntryPointRule();
        Assert.assertFalse( rule.evaluate( DomainEntryPoint.AllergyAssessment ) );
    }
    
    @Test( expected = IllegalArgumentException.class )
    @Suite( groups = { "checkintest" } )
    public void testBadDomainEntryPointEvaluateTrue()
    {
        DomainEntryPointRule rule = new DomainEntryPointRule();
        rule.setEntryPoint( "AllergyAssessmentBad" );
        
        Set<DomainEntryPoint> domainEntryPoints = new HashSet<DomainEntryPoint>();
        domainEntryPoints.add( DomainEntryPoint.IntoleranceCondition );
        domainEntryPoints.add( DomainEntryPoint.AllergyAssessment );
        
        Assert.assertFalse( rule.evaluate( domainEntryPoints ) );
    }
}
