package gov.va.med.cds.persistence.hibernate;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class VistaPersonIdentifierQueryParameterTransformerTest
{

    @Before
    public void setUp( )
        throws Exception
    {
    }


    @After
    public void tearDown( )
        throws Exception
    {
    }


    @Test
    public void testTransformAndSetParameter( )
    {
        List<String> pids = new ArrayList<String>();
        pids.add("1");
        pids.add("2");
        pids.add("3");
        Map<String, Object> parameterMap = new HashMap<String, Object>();
        
        VistaPersonIdentifierQueryParameterTransformer transformer = new VistaPersonIdentifierQueryParameterTransformer();
        transformer.transformAndSetParameter( "pids", pids, parameterMap );
        
        List<BigDecimal> vistaPids = (List<BigDecimal>) parameterMap.get("pids");
        
        assertNotNull( vistaPids );
        assertTrue( vistaPids.size() == 3 );
        assertTrue( vistaPids.get( 0 ).equals( new BigDecimal(1) ));
        assertTrue( vistaPids.get( 1 ).equals( new BigDecimal(2) ));
        assertTrue( vistaPids.get( 2 ).equals( new BigDecimal(3) ));
    }
    
    @Test(expected=IllegalArgumentException.class)
    public void testTransformAndSetParameterArrayError( )
    {
        Map<String, Object> parametersMap = new HashMap<String, Object>();
        String[] pids = new String[] {"1", "2", "3"};
        
        VistaPersonIdentifierQueryParameterTransformer transformer = new VistaPersonIdentifierQueryParameterTransformer();
        transformer.transformAndSetParameter( "pids", pids, parametersMap );
    }

}
