package gov.va.med.cds.persistence.hibernate;

import static org.easymock.EasyMock.createMock;
import static org.easymock.EasyMock.expect;
import static org.easymock.EasyMock.replay;
import static org.easymock.EasyMock.verify;
import static org.junit.Assert.*;
import gov.va.med.cds.filter.EntryFilterInterface;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OptionalParameterQueryNameBuilderTest
{

    @Before
    public void setUp( )
        throws Exception
    {
    }


    @After
    public void tearDown( )
        throws Exception
    {
    }


    @Test
    public void testBuildQueryNameHasRecordIdentifiersAndXpath( )
    {
        String associationName = "association";
        
        // create mock classes to use in test
        EntryFilterInterface entryFilter = createMock(EntryFilterInterface.class);
        
        // set the expectations for the mocks
        expect( entryFilter.getTemplateId()).andReturn( "templateId" );
        expect( entryFilter.getDomainEntryPoint()).andReturn( "domainEntryPoint" );
        expect( entryFilter.hasRecordIdentifiers()).andReturn( true );
        
        
        // prepare the mocks for use in test
        replay( entryFilter );
        
        QueryNameBuilderInterface queryNameBuilder = new OptionalParameterQueryNameBuilder();
        String queryName = queryNameBuilder.buildQueryName( entryFilter, associationName );
        
        // verify that expectations were met
        assertEquals( "templateId.domainEntryPoint.association.identifiers", queryName );
        verify( entryFilter );
    }
    
    @Test
    public void testBuildQueryNameUsesDates( )
    {
        String associationName = "association";
        
        // create mock classes to use in test
        EntryFilterInterface entryFilter = createMock(EntryFilterInterface.class);
        
        // set the expectations for the mocks
        expect( entryFilter.getTemplateId()).andReturn( "templateId" );
        expect( entryFilter.getDomainEntryPoint()).andReturn( "domainEntryPoint" );
        expect( entryFilter.hasRecordIdentifiers()).andReturn( false );
        expect( entryFilter.useDates()).andReturn( true );
        
        
        // prepare the mocks for use in test
        replay( entryFilter );
        
        QueryNameBuilderInterface queryNameBuilder = new OptionalParameterQueryNameBuilder();
        String queryName = queryNameBuilder.buildQueryName( entryFilter, associationName );
        
        // verify that expectations were met
        assertEquals( "templateId.domainEntryPoint.association.date", queryName );
        verify( entryFilter );
    }

}
