

package gov.va.med.cds.persistence;


import gov.va.med.cds.filter.FilterServiceSimulatorNoOp;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.Collection;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingException;


@RunWith( SuiteAwareRunner.class )
public class JNDIDataSourceBindingLocatorTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetVistaDataSourceBindings( )
    {
        doTest(5);
    }
    
    private void doTest(int resultSize)
    {
        Collection<Binding> bindings = new ArrayList<Binding>();
        bindings.add( new Binding( "552", new NoOpDataSource() ) );
        bindings.add( new Binding( "578", new NoOpDataSource( ) ));
        bindings.add( new Binding( "772", new NoOpDataSource() ));
        bindings.add( new Binding( "882", new FilterServiceSimulatorNoOp() ));
        bindings.add( new Binding( "7722", new NoOpDataSource() ));
        bindings.add( new Binding( "77", new NoOpDataSource() ));
        String contextName = "java:jdbc/gov/va/med/cds/vista";

        Context initialContext = EasyMock.createMock( Context.class );
        try
        {
            EasyMock.expect( initialContext.listBindings( contextName ) ).andReturn( new NamingEnumerationImpl(bindings) );
        }
        catch ( NamingException ex )
        {
            Assert.fail( "NamingException thrown "+ex );
        }
        EasyMock.replay( initialContext );
        JNDIDataSourceBindingsLocator dataSourceBindingsLocator = new JNDIDataSourceBindingsLocator();
        dataSourceBindingsLocator.setInitialContext( initialContext );
        dataSourceBindingsLocator.setNamedContext( contextName );

        Collection<Binding> results = dataSourceBindingsLocator.getDataSourceBindings();
        Assert.assertTrue( "Results size != "+resultSize+"; but " + results.size(), results.size() == resultSize );
    }
}
