

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadDemographicsTest
    extends
        AbstractEndToEndTest
{
    private static final String XPATH_DEMOGRAPHICS = "/demographicsdata:DemographicsData/patients/patient/demographics/demographic";
    private static final String XPATH_ERRORSECTION = "//errorSection";
    private static final String XPATH_ERRORSECTION_WARNING = "/demographicsdata:DemographicsData/errorSection/warnings/warning";
    private static final String XPATH_ERRORSECTION_WARNING_ERRORCODE = "/demographicsdata:DemographicsData/errorSection/warnings/warning/errorCode";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_ERROR = "/demographicsdata:DemographicsData/errorSection/errors/error";
    private static final String XPATH_ERRORSECTION_ERROR_ERRORCODE = "/demographicsdata:DemographicsData/errorSection/errors/error/errorCode";
    private static final String XPATH_ERRORSECTION_FATALERROR = "/demographicsdata:DemographicsData/errorSection/fatalErrors/fatalError";
    private static final String XPATH_ERRORSECTION_FATALERROR_ERRORCODE = "/demographicsdata:DemographicsData/errorSection/fatalErrors/fatalError/errorCode";
    @SuppressWarnings( "unused" )
    private static final String XPATH_ERRORSECTION_WARNING_DISPLAYMSG = "/demographicsdata:DemographicsData/errorSection/warnings/warning/displayMessage";
    private static final String XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG = "/demographicsdata:DemographicsData/errorSection/fatalErrors/fatalError/displayMessage";

    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";
    private static final String ASSIGNING_FACILITY_VISTA_578 = "578";
    private static final String PATIENT_IDENTITY_VISTA = "50";
    private static final String ASSIGNING_FACILITY_VISTA_580 = "580";

    @Resource
    private RequestProcessorInterface rpcRequestProcessor = null;
    protected TemplateRequestProcessor templateRequestProcessor;


    @Before
    @Suite( groups = { "deprecatedtest" } )
    public void beforeEndToEndReadVrmTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRpcRequestProcessor();
    }


    protected RequestProcessorInterface getRpcRequestProcessor( )
    {
        return rpcRequestProcessor;
    }


    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testDemographicsRead_MultiSite( )
    {
        String clientRequestInitiationTime = "2015-05-05T12:00:00Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA };
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient578, vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Demographic" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Demographic-Standard" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.DEMOGRAPHICS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.DEMOGRAPHICS_READ_TEMPLATE_ID,
                        TemplateIdHelper.DEMOGRAPHICS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_DEMOGRAPHICS );
        assertTrue( elementList.size() == 2 );

    }


    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testDemographicsRead_MultiSite_WithDate( )
    {
        String startDate = "2014-03-01"; 
        String endDate = "2015-03-01"; 
        
        String clientRequestInitiationTime = "2015-05-05T12:00:00Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient578 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA };
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient578, vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Demographic" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Demographic-Standard" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.DEMOGRAPHICS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.DEMOGRAPHICS_READ_TEMPLATE_ID,
                        TemplateIdHelper.DEMOGRAPHICS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_DEMOGRAPHICS );
        assertTrue( elementList.size() == 2 );

    }


    private Document readAndAssertDomainData( String demographicsReadTemplateId, String demographicsSinglePatientFilter, String requestId,
                    String filterXml, List<Map<String, String>> resolvedPatients )
    {
        templateRequestProcessor.setValidateReadResponseXML( true );
        Document dataDocument = templateRequestProcessor.readClinicalData( demographicsReadTemplateId, filterXml, demographicsSinglePatientFilter,
                        requestId );
        assertNotNull( dataDocument );

        return dataDocument;
    }

}
