

package gov.va.med.cds.integration;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.request.ReadResponseInterface;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;
import gov.va.med.cds.vdm.ClinicalDataInterface;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import org.dom4j.Document;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xml.sax.SAXException;


/**
 *
 * EndToEndReadNoFilterTest is responsible for:
 *
 */
@RunWith( SuiteAwareRunner.class )
public abstract class AbstractEndToEndResultsAssemblerTest
    extends
        AbstractEndToEndTest
{
    protected static final String ALLERGY_PHARMACY_IDENTIFIER = "test_IC_OPP_1009";
    protected static final String IC_IDENTIFIER = "test_IC_1008";
    protected static final String ALLERGY_ASSESSMENT_IDENTIFIER = "test_AA_1007";
    protected static final String OPP_MEDICATION_IDENTIFIER = "test_OPP_1006";
    protected static final String LAB_IDENTIFIER = "test_LAB_1006";
    protected static final String VITAL_IDENTIFIER = "test_VS_1006";
    protected static final String DEFAULT_ASSIGNING_FAC_UNIVERSAL_ID = "DNS   -605";


    protected abstract String createIdentityDomainEntryPointFilter( PersonIdentifierInterface sourceId, DomainEntryPoint... aDomainEntryPoint );


    protected abstract String createIdentityDomainEntryPointFilter( List<PersonIdentifierInterface> aPatients, DomainEntryPoint... aDomainEntryPoint );


    protected abstract ClinicalDataInterface makeClinicalDataRecord( PersonIdentifierInterface sourceId, String aTemplateId )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException;


    // Read Template Ids
    protected abstract String getIntoleranceConditionReadTemplateID( );


    protected abstract String getAllergyAssessmentReadTemplateID( );


    protected abstract String getPharmacyReadTemplateID( );


    protected abstract String getLabReadTemplateID( );


    protected abstract String getVitalReadTemplateID( );


    protected abstract String getIntoleranceConditionPharmacyReadTemplateID( );


    // Create Template Ids
    protected abstract String getIntoleranceConditionCreateTemplateID( );


    protected abstract String getAllergyAssessmentCreateTemplateID( );


    protected abstract String getPharmacyCreateTemplateID( );


    protected abstract String getLabCreateTemplateID( );


    protected abstract String getVitalCreateTemplateID( );


//    protected abstract ClinicalDataInterface unmarshallReadResults( ReadResponseInterface readResult )
//        throws SAXException,
//            IOException,
//            ParserConfigurationException,
//            XmlCompareException;


    protected abstract Map<String, Map<String, Map<DomainEntryPoint, Integer>>> countAllPatientData( Document clincialDocument )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException;


    protected abstract int countClinicalDataPatients( ClinicalDataInterface aClinicalDataInterface );


    protected abstract void prepareAndCreateDataForTest( ClinicalDataInterface aVdmClinicalDataInsert )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException;


    protected abstract void createClinicalData( String aTemplateId, String aControlXml );


    protected String makeKeyFromPersonIdentifier( PersonIdentifierInterface aPersonIdentifier )
    {
        String key = aPersonIdentifier.getIdentity() + aPersonIdentifier.getAssigningFacility();

        return key;
    }


    protected PersonIdentifierInterface createPersonIdentifier( String aEntityIdentifier, String aAssigningFacUniversalId )
    {
    	PersonIdentifierInterface newPersonIdentifier = new PersonIdentifier();
        newPersonIdentifier.setIdentity( aEntityIdentifier );
        newPersonIdentifier.setAssigningFacility( aAssigningFacUniversalId );
        return newPersonIdentifier;
    }


    protected List<PersonIdentifierInterface> createPersonIdentifier( PersonIdentifier... aPersonIdentifiers )
    {
        List<PersonIdentifierInterface> sourceIds = new ArrayList<PersonIdentifierInterface>();
        for ( int i = 0; i < aPersonIdentifiers.length; i++ )
        {
            sourceIds.add( aPersonIdentifiers[i] );
        }

        return sourceIds;
    }


    protected void doReadCreateClinicalDataAndCompareRecordCounts( String readTemplateId, String createTemplateId,
                    PersonIdentifierInterface sourceId, DomainEntryPoint outpatientmedicationpromise )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        String subjectKey = makeKeyFromPersonIdentifier( sourceId );

        List<PersonIdentifierInterface> subjects = new ArrayList<PersonIdentifierInterface>();
        subjects.add( sourceId );
        // create a filter for this subject and domainEntryPoint
        String filter = createIdentityDomainEntryPointFilter( subjects, outpatientmedicationpromise );

        // retrieve the OutpatientMedicationPromise by identifier and count the current number of records
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> beforePatientDataCount = readUnmarshalAndCountDomainData( readTemplateId, filter, 1 );

        // now add an additional record
        makeClinicalDataRecord( sourceId, createTemplateId );

        // again retrieve the OutpatientMedicationPromise by identifier and count the current number of records
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> afterPatientDataCount = readUnmarshalAndCountDomainData( readTemplateId, filter, 1 );

        // and get the new count of records
        compareBeforeAndAfterData( beforePatientDataCount.get( subjectKey ), afterPatientDataCount.get( subjectKey ), subjectKey, 1, outpatientmedicationpromise );
    }


    @Ignore
    @Test
    // Fix Me R.S.
    @Suite( groups = { "prototypetest" } )
    public void testOutpatientMedicationPromiseReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        PersonIdentifierInterface sourceId = createPersonIdentifier( OPP_MEDICATION_IDENTIFIER, DEFAULT_ASSIGNING_FAC_UNIVERSAL_ID );
        doReadCreateClinicalDataAndCompareRecordCounts( getPharmacyReadTemplateID(), getPharmacyCreateTemplateID(), sourceId,
                        DomainEntryPoint.OutpatientMedicationPromise );
    }


    @Ignore
    @Test
    // Fix Me R.S.
    @Suite( groups = { "prototypetest" } )
    public void testVitalSignObservationEventReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        PersonIdentifierInterface sourceId = createPersonIdentifier( VITAL_IDENTIFIER, DEFAULT_ASSIGNING_FAC_UNIVERSAL_ID );
        doReadCreateClinicalDataAndCompareRecordCounts( getVitalReadTemplateID(), getVitalCreateTemplateID(), sourceId,
                        DomainEntryPoint.VitalSignObservationEvent );
    }


    @Ignore
    @Test
    @Suite( groups = { "prototypetest" } )
    public void testLabTestPromiseReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
    	PersonIdentifierInterface sourceId = createPersonIdentifier( LAB_IDENTIFIER, DEFAULT_ASSIGNING_FAC_UNIVERSAL_ID );
        doReadCreateClinicalDataAndCompareRecordCounts( getLabReadTemplateID(), getLabCreateTemplateID(), sourceId, DomainEntryPoint.LabTestPromise );
    }


    @Ignore
    @Test
    @Suite( groups = { "prototypetest" } )
    public void testAllergiesAssessmentReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
    	PersonIdentifierInterface sourceId = createPersonIdentifier( ALLERGY_ASSESSMENT_IDENTIFIER, DEFAULT_ASSIGNING_FAC_UNIVERSAL_ID );
        doReadCreateClinicalDataAndCompareRecordCounts( getAllergyAssessmentReadTemplateID(), getAllergyAssessmentCreateTemplateID(), sourceId,
                        DomainEntryPoint.AllergyAssessment );
    }


    @Ignore
    @Test
    // Fix Me R.S.
    @Suite( groups = { "prototypetest" } )
    public void testIntoleranceConditionReadCreateRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
    	PersonIdentifierInterface sourceId = createPersonIdentifier( IC_IDENTIFIER, DEFAULT_ASSIGNING_FAC_UNIVERSAL_ID );
        doReadCreateClinicalDataAndCompareRecordCounts( getIntoleranceConditionReadTemplateID(), getIntoleranceConditionCreateTemplateID(), sourceId,
                        DomainEntryPoint.IntoleranceCondition );
    }


    @Ignore
    @Test
    // Fix Me R.S.
    @Suite( groups = { "prototypetest" } )
    public void testMultiEntryPointRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        // make a single PersonIdentifier subject
    	PersonIdentifierInterface patientIdentifier = createPersonIdentifier( ALLERGY_PHARMACY_IDENTIFIER, DEFAULT_ASSIGNING_FAC_UNIVERSAL_ID );
        String key = makeKeyFromPersonIdentifier( patientIdentifier );

        List<PersonIdentifierInterface> subjects = new ArrayList<PersonIdentifierInterface>();
        subjects.add( patientIdentifier );

        // get a multi-domain template
        String templateId = getIntoleranceConditionPharmacyReadTemplateID();
        // make a multi-domain filter for single-PersonIdentifier subject
        String filter = createIdentityDomainEntryPointFilter( subjects, DomainEntryPoint.IntoleranceCondition,
                        DomainEntryPoint.OutpatientMedicationPromise );

        // retrieve the existing multi-domain data for this single-PersonIdentifier subject
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> beforePatientDataCount = readUnmarshalAndCountDomainData( templateId, filter, 1 );

        // now add an additional IntoleranceCondition and OutpatientMedicationPromise record
        makeClinicalDataRecord( patientIdentifier, getIntoleranceConditionCreateTemplateID() );
        makeClinicalDataRecord( patientIdentifier, getPharmacyCreateTemplateID() );

        // again retrieve the multi-domain data for this single-PersonIdentifier subject
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> afterPatientDataCountAB = readUnmarshalAndCountDomainData( templateId, filter, 1 );

        // now make sure we read the correct number of records
        compareBeforeAndAfterData( beforePatientDataCount.get( key ), afterPatientDataCountAB.get( key ), key, 1,
                        DomainEntryPoint.IntoleranceCondition, DomainEntryPoint.OutpatientMedicationPromise );

    }


    @Ignore
    @Test
    // Fix Me R.S.
    @Suite( groups = { "prototypetest" } )
    public void testMultiEntryPointMultiPatientWriteRead( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        // make a multi-PersonIdentifier subject
        PersonIdentifierInterface patientIdentifierA = createPersonIdentifier( "test_sourceId_A", "VISN_A" );
        String keyA = makeKeyFromPersonIdentifier( patientIdentifierA );

        PersonIdentifierInterface patientIdentifierB = createPersonIdentifier( "test_sourceId_B", "VISN_B" );
        String keyB = makeKeyFromPersonIdentifier( patientIdentifierB );

        List<PersonIdentifierInterface> subjects = new ArrayList<PersonIdentifierInterface>();
        subjects.add( patientIdentifierA );
        subjects.add( patientIdentifierB );
        

        // get a multi-domain template
        String templateId = getIntoleranceConditionPharmacyReadTemplateID();
        // make a multi-domain filter for the multi-PersonIdentifier subject1
        String filter = createIdentityDomainEntryPointFilter( subjects, DomainEntryPoint.IntoleranceCondition,
                        DomainEntryPoint.OutpatientMedicationPromise );

        // retrieve the existing multi-domain data for this multi-PersonIdentifier subject1
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> beforePatientDataCountAB = readUnmarshalAndCountDomainData( templateId, filter, 1 );

        // now add an additional IntoleranceCondition and OutpatientMedicationPromise record for identifier A
        makeClinicalDataRecord( patientIdentifierA, getIntoleranceConditionCreateTemplateID() );
        makeClinicalDataRecord( patientIdentifierA, getPharmacyCreateTemplateID() );

        // now add an additional OutpatientMedicationPromise record for identifier B
        makeClinicalDataRecord( patientIdentifierB, getPharmacyCreateTemplateID() );

        // again retrieve the multi-domain data for this multi-PersonIdentifier subject1
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> afterPatientDataCountAB = readUnmarshalAndCountDomainData( templateId, filter, 1 );

        // now we should have read the new data added and the counts should match.
        // patientIdentifierA with KeyA should have 1 new IntoleranceCondition record and 1 new
        // OutpatientMedicationPromise record
        String subjectKey1 = keyA + keyB;
        compareBeforeAndAfterData( beforePatientDataCountAB.get( subjectKey1 ), afterPatientDataCountAB.get( subjectKey1 ), keyA, 1,
                        DomainEntryPoint.IntoleranceCondition, DomainEntryPoint.OutpatientMedicationPromise );
        // patientIdentifierB with KeyB should have 1 new OutpatientMedicationPromise record
        compareBeforeAndAfterData( beforePatientDataCountAB.get( subjectKey1 ), afterPatientDataCountAB.get( subjectKey1 ), keyB, 1,
                        DomainEntryPoint.OutpatientMedicationPromise );

        // now do all of the above for a second subject
        // make another multi-Id subject
        subjects.clear();
        PersonIdentifierInterface patientIdentifierC = createPersonIdentifier( "test_sourceId_C", "VISN_C" );
        String keyC = makeKeyFromPersonIdentifier( patientIdentifierC );

        PersonIdentifierInterface patientIdentifierD = createPersonIdentifier( "test_sourceId_D", "VISN_D" );
        String keyD = makeKeyFromPersonIdentifier( patientIdentifierD );

        subjects.add( patientIdentifierC );
        subjects.add( patientIdentifierD );

        // make a multi-domain filter for the multi-Id subject2
        filter = createIdentityDomainEntryPointFilter( subjects, DomainEntryPoint.IntoleranceCondition, DomainEntryPoint.OutpatientMedicationPromise );

        // retrieve the existing multi-domain data for this multi-PersonIdentifier subject2
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> beforePatientDataCountCD = readUnmarshalAndCountDomainData( templateId, filter, 1 );

        // now add an additional IntoleranceCondition record for identifier C
        makeClinicalDataRecord( patientIdentifierC, getIntoleranceConditionCreateTemplateID() );

        // now add an additional IntoleranceCondition and OutpatientMedicationPromise record for identifier D
        makeClinicalDataRecord( patientIdentifierD, getPharmacyCreateTemplateID() );
        makeClinicalDataRecord( patientIdentifierD, getIntoleranceConditionCreateTemplateID() );

        // again retrieve the multi-domain data for this multi-PersonIdentifier subject2
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> afterPatientDataCountCD = readUnmarshalAndCountDomainData( templateId, filter, 1 );

        // now we should have read the new data added and the counts should match.
        // patientIdentifierC with KeyC should have 1 new IntoleranceCondition record
        String subjectKey2 = keyC + keyD;
        compareBeforeAndAfterData( beforePatientDataCountCD.get( subjectKey2 ), afterPatientDataCountCD.get( subjectKey2 ), keyC, 1,
                        DomainEntryPoint.IntoleranceCondition );
        // patientIdentifierD with KeyD should have 1 new IntoleranceCondition record and 1 new
        // OutpatientMedicationPromise record
        compareBeforeAndAfterData( beforePatientDataCountCD.get( subjectKey2 ), afterPatientDataCountCD.get( subjectKey2 ), keyD, 1,
                        DomainEntryPoint.IntoleranceCondition, DomainEntryPoint.OutpatientMedicationPromise );

        // Now create a multi-subject filter and read the data
        subjects.clear();
        subjects.add( patientIdentifierA );
        subjects.add( patientIdentifierB );
        subjects.add( patientIdentifierC );
        subjects.add( patientIdentifierD );
        filter = createIdentityDomainEntryPointFilter( subjects, DomainEntryPoint.IntoleranceCondition, DomainEntryPoint.OutpatientMedicationPromise );

        // retrieve the IntoleranceCondition and pharmacy by subject (multi identifiers) for second subject.
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> multiPatientDataCount = readUnmarshalAndCountDomainData( templateId, filter, 2 );

        compareBeforeAndAfterData( multiPatientDataCount.get( subjectKey1 ), afterPatientDataCountAB.get( subjectKey1 ), keyA, 0,
                        DomainEntryPoint.IntoleranceCondition, DomainEntryPoint.OutpatientMedicationPromise );
        compareBeforeAndAfterData( multiPatientDataCount.get( subjectKey1 ), afterPatientDataCountAB.get( subjectKey1 ), keyB, 0,
                        DomainEntryPoint.OutpatientMedicationPromise );
        compareBeforeAndAfterData( multiPatientDataCount.get( subjectKey2 ), afterPatientDataCountCD.get( subjectKey2 ), keyC, 0,
                        DomainEntryPoint.IntoleranceCondition );
        compareBeforeAndAfterData( multiPatientDataCount.get( subjectKey2 ), afterPatientDataCountCD.get( subjectKey2 ), keyD, 0,
                        DomainEntryPoint.IntoleranceCondition, DomainEntryPoint.OutpatientMedicationPromise );
    }


    protected Map<String, Map<String, Map<DomainEntryPoint, Integer>>> readUnmarshalAndCountDomainData( String aTemplateId, String aFilter,
                    int aRequiredPatientCount )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        // read the record using the parameters passed in.
        Document readResult = getRequestProcessor().readClinicalData( aTemplateId, aFilter, null, new UniqueIdentifier().toString() );
        // now unmarshal the results into a vdm clinical data object that implements the clinical data interface
        //TODO: rework to use builders / dom4j - unmarshall won't be used - can work with document readResult directly
        //ClinicalDataInterface clinicalData = unmarshallReadResults( readResult );
        // now count result and return to caller
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> patientDataCount = countAllPatientData( readResult );
        // Assert that the required number of patients was read
        //TODO: rework to use builders / dom4j
        //assertTrue( countClinicalDataPatients( clinicalData ) == aRequiredPatientCount );
        return patientDataCount;
    }


    private void compareBeforeAndAfterData( Map<String, Map<DomainEntryPoint, Integer>> beforePatientDataCount,
                    Map<String, Map<DomainEntryPoint, Integer>> afterPatientDataCount, String aPersonIdentifier, int countDelta,
                    DomainEntryPoint... aDomainEntryPoints )
    {
        Map<DomainEntryPoint, Integer> beforeDomainDataCountMap = beforePatientDataCount.get( aPersonIdentifier );
        assertNotNull( beforeDomainDataCountMap );
        Map<DomainEntryPoint, Integer> afterDomainDataCountMap = afterPatientDataCount.get( aPersonIdentifier );
        assertNotNull( afterDomainDataCountMap );
        for ( DomainEntryPoint domainEntryPoint : aDomainEntryPoints )
        {
            assertTrue( afterDomainDataCountMap.get( domainEntryPoint ) == beforeDomainDataCountMap.get( domainEntryPoint ) + countDelta );
        }
    }


    //LAURY Start to LOOK HERE ...and below -
    private void compareBeforeAndAfterDataWithConfigurator( Map<String, Map<DomainEntryPoint, Integer>> beforePatientDataCount,
                    Map<String, Map<DomainEntryPoint, Integer>> afterPatientDataCount, DomainPatientConfigurator configurator )
    {
        for ( DomainCreateConfigurator createConfig : configurator.getCreateConfigurators() )
        {
            String sourceIdKey = makeKeyFromPersonIdentifier( createConfig.getSourcePatient() );
            compareBeforeAndAfterData( beforePatientDataCount, afterPatientDataCount, sourceIdKey, createConfig.getNewRecordCount() );
        }
    }


    //LAURY - this test is ok - still getting into some complex shit - but it does start to have some configurable
    //flexibility - still only single subject (right now my subject configurator is replacing our use of subject
    //but I think we may bring that back and refactor into something that takes this idea - but across multiple
    //subjects and perhaps stuffing the comparison maps into another object that holds the 'Great Map' and the ClinicalDataInterface for value xml comparisons...
    //until I can make a few more passes with this many of my new methods are wrapping existing methods ... but I think we
    //can rework all this to fuse a lot of it.

    ///ACTUALLY AFTER I WROTE A LOT OF THIS I added some work towards multiple subjects - and multiple sourceId in a subject - but not finished
    @Ignore
    @Test
    // Fix Me R.S.
    @Suite( groups = { "prototypetest" } )
    public void testMultiEntryPointReadFromConfiguratorsSingleSource( )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException
    {
        // make a single PersonIdentifier subject
        PersonIdentifierInterface patientIdentifier = createPersonIdentifier( "test_config_source_1", "VISN_CONFIG_1" );
        String key = makeKeyFromPersonIdentifier( patientIdentifier );

        List<PersonIdentifierInterface> subjects = new ArrayList<PersonIdentifierInterface>();
        subjects.add( patientIdentifier );

        DomainPatientConfigurator configurator = assembleConfigurator( subjects );//maybe we can get this reworked to use subject

        // retrieve the existing multi-domain data for this single-PersonIdentifier subject
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> beforePatientDataCount = readUnmarshalAndCountDomainData( configurator
                        .getReadTemplateId(), configurator.getFilter(), 1 );

        // make new clinical records
        makeClinicalDataRecordsWithConfigurator( configurator );

        // again retrieve the multi-domain data for this single-PersonIdentifier subject
        Map<String, Map<String, Map<DomainEntryPoint, Integer>>> afterPatientDataCount = readUnmarshalAndCountDomainData( configurator
                        .getReadTemplateId(), configurator.getFilter(), 1 );

        // now make sure we read the correct number of records
        compareBeforeAndAfterDataWithConfigurator( beforePatientDataCount.get( key ), afterPatientDataCount.get( key ), configurator );
    }


    protected abstract DomainPatientConfigurator assembleConfigurator( List<PersonIdentifierInterface> subjects );


    protected abstract void initializeTemplateCombinations( );


    protected abstract void makeClinicalDataRecordsWithConfigurator( DomainPatientConfigurator configurator )
        throws SAXException,
            IOException,
            ParserConfigurationException,
            XmlCompareException;

    /**
     * Class defines configuration for a set of DomainCreateConfigurator objects and a read template id that is based
     * upon the contents of the createConfigurator list.
     *
     * @author DNS   TALBOM
     *
     */
    public class DomainPatientConfigurator
    {
        private String readTemplateId = null;
        private List<DomainCreateConfigurator> createConfigurators = new ArrayList<DomainCreateConfigurator>();
        private String filter = null;
        private List<DomainEntryPoint> domainEntryPoints = new ArrayList<DomainEntryPoint>();


        public String getReadTemplateId( )
        {
            return readTemplateId;
        }


        public void setReadTemplateId( String readTemplateId )
        {
            this.readTemplateId = readTemplateId;
        }


        public List<DomainCreateConfigurator> getCreateConfigurators( )
        {
            return createConfigurators;
        }


        public void setCreateConfigurators( List<DomainCreateConfigurator> createConfigurators )
        {
            this.createConfigurators = createConfigurators;
        }


        public void addCreateConfigurator( DomainCreateConfigurator createConfigurator )
        {
            createConfigurators.add( createConfigurator );
        }


        public String getFilter( )
        {
            return filter;
        }


        public void setFilter( String filter )
        {
            this.filter = filter;
        }


        public List<DomainEntryPoint> getDomainEntryPoints( )
        {
            return domainEntryPoints;
        }


        public void setDomainEntryPoints( List<DomainEntryPoint> domainEntryPoints )
        {
            this.domainEntryPoints = domainEntryPoints;
        }


        public void addDomainEntryPoint( DomainEntryPoint entryPoint )
        {
            domainEntryPoints.add( entryPoint );
        }

    }

    /**
     * Class defines configuration of a single domain entry point record creation for a single sourceId patient and the
     * number of create records desired for the entry point.
     *
     * @author DNS   TALBOM
     *
     */
    public class DomainCreateConfigurator
    {

        private PersonIdentifierInterface sourcePatient = null;
        private String createTemplateId = null;
        private DomainEntryPoint domainEntryPoint = null;

        private int newRecordCount = 0;


        public DomainCreateConfigurator( PersonIdentifierInterface sourceId, String createTemplateId, int recordCount, DomainEntryPoint entryPoint )
        {
            this.sourcePatient = sourceId;
            this.createTemplateId = createTemplateId;
            this.newRecordCount = recordCount;
            this.domainEntryPoint = entryPoint;
        }


        public PersonIdentifierInterface getSourcePatient( )
        {
            return sourcePatient;
        }


        public void setSourcePatient( PersonIdentifier sourcePatient )
        {
            this.sourcePatient = sourcePatient;
        }


        public String getCreateTemplateId( )
        {
            return createTemplateId;
        }


        public void setCreateTemplateId( String createTemplateId )
        {
            this.createTemplateId = createTemplateId;
        }


        public int getNewRecordCount( )
        {
            return newRecordCount;
        }


        public void setNewRecordCount( int newRecordCount )
        {
            this.newRecordCount = newRecordCount;
        }


        public DomainEntryPoint getDomainEntryPoint( )
        {
            return domainEntryPoint;
        }


        public void setDomainEntryPoint( DomainEntryPoint domainEntryPoint )
        {
            this.domainEntryPoint = domainEntryPoint;
        }
    }
}
