package gov.va.med.cds.filter;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.dom4j.Element;
import org.easymock.EasyMock;
import org.junit.BeforeClass;
import org.junit.Test;

public class EntryFilterFactoryTest
{
    
    private static EntryFilterFactory entryFilterFactory = null;
    
    @BeforeClass
    public static void beforeClass() throws Exception
    {
        Map<String, Class<EntryFilterInterface>> filterIdToEntryFilterClassMap = new HashMap<String, Class<EntryFilterInterface>>();
        filterIdToEntryFilterClassMap.put( "FILTER_100", (Class<EntryFilterInterface>)Class.forName( "gov.va.med.cds.filter.Filter100QueryMetadata" ) );
        
        EntryFilterFactoryTest.entryFilterFactory = new EntryFilterFactory();
        entryFilterFactory.setFilterIdToEntryFilterClassMap( filterIdToEntryFilterClassMap );
    }

   @Test
    public void testCreateEntryFilterDefault( )
    {
        Element entryFilterMock = EasyMock.createMock( Element.class );
        Element domainEntryPointMock = EasyMock.createMock( Element.class );
        EasyMock.expect( entryFilterMock.attributeValue( "queryName" ) ).andReturn("queryName");
        EasyMock.expect( entryFilterMock.attributeValue( "countOnly" ) ).andReturn("false");
        EasyMock.expect( entryFilterMock.attributeValue( "pageNumber" ) ).andReturn(null);
        EasyMock.expect( entryFilterMock.attributeValue( "pageSize" ) ).andReturn(null);
        EasyMock.expect( entryFilterMock.attributeValue( "isPatientCentric" ) ).andReturn("false").anyTimes();
        EasyMock.expect( entryFilterMock.attributeValue( "isSiteCentric" ) ).andReturn(null).anyTimes();
        EasyMock.expect( entryFilterMock.attributeValue( "facilityId" ) ).andReturn(null).anyTimes();
        EasyMock.expect( entryFilterMock.elements() ).andReturn(new ArrayList<Element>());
        EasyMock.expect( entryFilterMock.element( "domainEntryPoint" ) ).andReturn( domainEntryPointMock );
        EasyMock.expect( domainEntryPointMock.getTextTrim() ).andReturn("domainEntryPointText");
        EasyMock.expect( entryFilterMock.element( EasyMock.anyObject( String.class ) ) ).andReturn( null ).anyTimes();
        EasyMock.expect( entryFilterMock.elements( EasyMock.anyObject( String.class ) ) ).andReturn( null ).anyTimes();
        
        
        EasyMock.replay( entryFilterMock, domainEntryPointMock );
        
        EntryFilterInterface entryFilterInterface = entryFilterFactory.createEntryFilter( "SOME_FILTER", "SOME_TEMPLATE", entryFilterMock, UUID.randomUUID().toString() );
        assertTrue(entryFilterInterface instanceof FilterQueryMetadata);
        EasyMock.verify( entryFilterMock, domainEntryPointMock );
    }
    
    @Test
    public void testCreateEntryFilter100()
    {
        Element entryFilterMock = EasyMock.createMock( Element.class );
        Element domainEntryPointMock = EasyMock.createMock( Element.class );
        EasyMock.expect( entryFilterMock.attributeValue( "queryName" ) ).andReturn("queryName");
        EasyMock.expect( entryFilterMock.attributeValue( "countOnly" ) ).andReturn("false");
        EasyMock.expect( entryFilterMock.attributeValue( "pageNumber" ) ).andReturn(null);
        EasyMock.expect( entryFilterMock.attributeValue( "pageSize" ) ).andReturn(null);
        EasyMock.expect( entryFilterMock.attributeValue( "isPatientCentric" ) ).andReturn("false").anyTimes();
        EasyMock.expect( entryFilterMock.attributeValue( "isSiteCentric" ) ).andReturn(null).anyTimes();
        EasyMock.expect( entryFilterMock.attributeValue( "facilityId" ) ).andReturn(null).anyTimes();
        EasyMock.expect( entryFilterMock.elements() ).andReturn(new ArrayList<Element>());
        EasyMock.expect( entryFilterMock.element( "domainEntryPoint" ) ).andReturn( domainEntryPointMock );
        EasyMock.expect( domainEntryPointMock.getTextTrim() ).andReturn("domainEntryPointText");
        EasyMock.expect( entryFilterMock.element( EasyMock.anyObject( String.class ) ) ).andReturn( null ).anyTimes();
        EasyMock.expect( entryFilterMock.elements( EasyMock.anyObject( String.class ) ) ).andReturn( null ).anyTimes();
        
        
        EasyMock.replay( entryFilterMock, domainEntryPointMock );
        
        EntryFilterInterface entryFilterInterface = entryFilterFactory.createEntryFilter( "FILTER_100", "SOME_TEMPLATE", entryFilterMock, UUID.randomUUID().toString() );
        assertTrue(entryFilterInterface instanceof Filter100QueryMetadata);
        EasyMock.verify( entryFilterMock, domainEntryPointMock );
    }

}
