

package gov.va.med.cds.util;


import java.io.File;


public class ConstructedSearchPathGenerator
    implements
        SearchPathGeneratorInterface
{
    private static final String URL_PREFIX = "file:";
    private String firstSystemProperty = null;
    private String secondSystemProperty = null;
    private String firstPiece = null;
    private String secondPiece = null;


    /**
     * 
     * @see gov.va.med.cds.util.SearchPathGeneratorInterface#getSearchPath()
     */
    public String getSearchPath( )
    {
        return URL_PREFIX + System.getProperty( firstSystemProperty ) + File.separatorChar + firstPiece + File.separatorChar
                        + System.getProperty( secondSystemProperty ) + File.separatorChar + secondPiece;
    }


    public void setFirstSystemPropertyName( String property )
    {
        this.firstSystemProperty = property;
    }


    public void setFirstFilePathPiece( String piece )
    {
        this.firstPiece = piece;
    }


    public void setSecondSystemPropertyName( String property )
    {
        this.secondSystemProperty = property;
    }


    public void setSecondFilePathPiece( String piece )
    {
        this.secondPiece = piece;
    }

}
