

package gov.va.med.cds.template;


import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.request.WriteRequestInterface;


/**
 *
 * Place holder for the request (CUAD) xml and request type.
 *
 */
public class TemplateWriteRequest
    implements
        WriteRequestInterface
{
    private String requestId;
    private String templateId;
    private String requestXml;
    private Operation operation;


    public TemplateWriteRequest( String aXmlRequest )
    {
        this( aXmlRequest, null );
    }


    public TemplateWriteRequest( String aXmlRequest, Operation aOperation )
    {
        setRequestData( aXmlRequest );
        setOperation( aOperation );
    }


    /**
    *
    * @see gov.va.med.cds.request.WriteRequestInterface#getRequestId()
    */
    public String getRequestId( )
    {
        return requestId;
    }


    /**
     *
     * @see gov.va.med.cds.request.WriteRequestInterface#setRequestId(java.lang.String)
     */
    public void setRequestId( String aRequestId )
    {
        if ( ( aRequestId == null ) || ( aRequestId.length() == 0 ) )
        {
            throw new ValidationException( ErrorCodeEnum.WRITE_REQUEST_REQUEST_ID_NULL );
        }

        requestId = aRequestId;
    }


    /**
    *
    * @see gov.va.med.cds.request.WriteRequestInterface#getTemplateId()
    */
    public String getTemplateId( )
    {
        return templateId;
    }


    /**
     *
     * @see gov.va.med.cds.request.WriteRequestInterface#setTemplateId(java.lang.String)
     */
    public void setTemplateId( String aTemplateId )
    {
        templateId = aTemplateId;
    }


    /**
     *
     * @see gov.va.med.cds.request.WriteRequestInterface#getRequestData()
     */
    public String getRequestData( )
    {
        return requestXml;
    }


    /**
     *
     * @see gov.va.med.cds.request.WriteRequestInterface#setRequestData(java.lang.String)
     */
    public void setRequestData( String aRequestData )
    {
        requestXml = aRequestData;
    }


    /**
     *
     * @see gov.va.med.cds.request.WriteRequestInterface#getOperation()
     */
    public Operation getOperation( )
    {
        return operation;
    }


    /**
     *
     * @see gov.va.med.cds.request.WriteRequestInterface#setOperation(gov.va.med.cds.clinicaldata.Operation)
     */
    public void setOperation( Operation operation )
    {
        this.operation = operation;
    }
}
