

package gov.va.med.cds.response.vhim400;


import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.response.WriteResponseGeneratorInterface;

import java.util.List;

import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;


public class WriteResponseGenerator
    implements
        WriteResponseGeneratorInterface
{

    protected ClinicalDataResponseInterface clinicalDataResponse = null;
    protected List<String> createdIdentifierResponseTemplates = null;


    @Override
    public Document generateSuccessfulWriteResponse( String templateId, String requestId, List<Element> createdIdentifiers )
    {
        return buildClinicalDataDocument( templateId, requestId, createdIdentifiers );
    }


    @Override
    public Element generateIdentifierElement( String recordIdentifier, Element clinicalData )
    {
        return this.clinicalDataResponse.buildRecordIdentifierElement( recordIdentifier, clinicalData );
    }


    protected Document buildClinicalDataDocument( String templateId, String requestId, List<Element> createdIdentifiers )
    {
        /* add created Identifiers for only those client's that allow HDR to create the unique identity/identifier for the record
         * other clients provide their own identifier for record creation*/
        if ( this.createdIdentifierResponseTemplates.contains( templateId ) )
        {
            return buildClinicalDataDocumentWithCreatedIdentifiers( templateId, requestId, createdIdentifiers );
        }
        else
        {
            return buildSimpleClinicalDataDocument( templateId, requestId );
        }

    }


    @Override
    public Document generateWriteErrorResponse( String templateId, String requestId, Exception exception, Document clinicalDataDocument,
                    String applicationName )
    {
        

        Document writeResultDocument = ExceptionHandler.handleException( exception, templateId, requestId, applicationName );
        writeResultDocument = this.clinicalDataResponse.buildErrorResponse( templateId, requestId, writeResultDocument, clinicalDataDocument );
        return writeResultDocument;
    }


    protected Document buildClinicalDataDocumentWithCreatedIdentifiers( String templateId, String requestId, List<Element> createdIdentifiers )
    {

        Document clinicalDataDocument = this.clinicalDataResponse.buildClinicalDocumentWithCreatedIdentifiers( templateId, requestId,
                        createdIdentifiers, false );
        return buildSuccessfulResponseDocument( clinicalDataDocument );
    }


    protected Document buildSimpleClinicalDataDocument( String templateId, String requestId )
    {
        Document clinicalDataDocument = this.clinicalDataResponse.buildEmptyClinicalDocument( templateId, requestId, false );
        return buildSuccessfulResponseDocument( clinicalDataDocument );
    }


    protected Document buildSuccessfulResponseDocument( Document clinicalDataDocument )
    {
        Element clinicalDataElement = clinicalDataDocument.getRootElement();

        //add an empty errorSection to indicate SUCCESS
        clinicalDataElement.addElement( "errorSection" );

        return clinicalDataDocument;
    }


    @Required
    public void setClinicalDataResponse( ClinicalDataResponseInterface clinicalDataResponse )
    {
        this.clinicalDataResponse = clinicalDataResponse;
    }


    @Required
    public void setCreatedIdentifierResponseTemplates( List<String> createdIdentifierResponseTemplates )
    {
        this.createdIdentifierResponseTemplates = createdIdentifierResponseTemplates;
    }

}
