/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author DNS   egberb
 * 
 * Class responsible for transforming the record identifiers to BigDecimals for VistA reads.
 *
 */
public class VistaRecordIdentifierQueryParameterTransformer
    implements
        QueryParameterTransformerInterface
{

    /* (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface#transformAndSetParameter(java.lang.String, java.lang.Object, java.util.Map)
     */
    @Override
    public void transformAndSetParameter( String parameterName, Object parameterValue, Map<String, Object> parameterMap )
    {
        parameterMap.put( parameterName, transform(parameterValue) );
    }
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface#transform(java.lang.Object)
     */
    @Override
    public Object transform( Object parameterValue )
    {
        if(parameterValue instanceof List)
        {
            List<String> recordIdentifiers = (List<String>)parameterValue;
            List<BigDecimal> floatRecordIdentifiers = new ArrayList<BigDecimal>();
    
            for ( String recordIdentifier : recordIdentifiers )
            {
    
                String id = recordIdentifier.substring( 0, recordIdentifier.indexOf( "/" ) );
                floatRecordIdentifiers.add( new BigDecimal( id ) );
            }
    
            return floatRecordIdentifiers;
        }
        else
        {
            throw new IllegalArgumentException("Parameter value for VistaRecordIdentifierQueryParameterTransformer must be of type list.");
        }
    }
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface#transform(java.lang.String)
     */
    @Override  
    public Object transform( String parameterValue )
    {
    	return null;
    }

}
