/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import java.math.BigDecimal;
import java.util.Map;

import gov.va.med.cds.persistence.QueryWorkInterface;

/**
 * @author DNS   egberb
 * 
 * A generic interface for transforming and getting query parameters into the query parameters 
 * map used by the query work object.
 * 
 * @see QueryWorkInterface
 *
 */
public interface QueryParameterTransformerInterface
{
    Object transform( Object parameterValue );
    
    Object transform( String parameterValue );
    
    void transformAndSetParameter(String parameterName, Object parameterValue, Map<String, Object> parameterMap);
}
