/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.filter.ParameterMapInterface;

/**
 * @author DNS   egberb
 *
 * Legacy implementation of the query name builder takes the input entry point and association name 
 * and resolves them to the name of the query to utilized when querying for observation based on 
 * the legacy naming convention for queries.
 */
public class LegacyQueryNameBuilder
    implements
        QueryNameBuilderInterface
{

    /* (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryNameBuilderInterface#buildQueryName(gov.va.med.cds.filter.EntryFilterInterface, java.lang.String)
     */
    @Override
    public String buildQueryName( EntryFilterInterface entryFilter, String associationName )
    {
        String queryName = String.format( "%s.%s.%s", entryFilter.getTemplateId(), entryFilter.getDomainEntryPoint(), associationName );

        if ( entryFilter.hasRecordIdentifiers() ) // query is by record identifier
        {
            queryName = String.format( "%s.identifiers", queryName );
        }
        else if ( entryFilter.useDates() ) // person ids and date query.
        {
            queryName = String.format( "%s.date", queryName );
        }
        
        ParameterMapInterface parameterMap = entryFilter.getAdditionalParametersMap();
        if ( parameterMap != null )
        {
            for ( String filterParameterName : parameterMap.getFilterParameterNames() )
            {
                queryName = String.format( "%s.%s", queryName, filterParameterName );
            }
        }
        
        if ( entryFilter.containsXpathFilterExpression() )
        {
            queryName = String.format( "%s.xpath", queryName );
        }

        return queryName;
    }

}
