/**
 * 
 */
package gov.va.med.cds.persistence;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.hibernate.PageableCriteriaQueryWork;

import java.util.List;

import org.hibernate.Session;

/**
 * @author DNS   egberb
 *
 */
public class PageableAssociationBasedCriteriaQueryStrategy
    extends
        PageableAssociationBasedQueryStrategy
{

    protected QueryWorkInterface createQueryWork( Session session, QueryAssociationInterface queryAssociation, EntryFilterInterface entryFilter,
                    List<String> personIdentifiers, Class<?> pointInTimeUserType, String siteId )
    {
        QueryWorkInterface queryWork = new PageableCriteriaQueryWork( session, queryAssociation, entryFilter, queryNameBuilder, filterParameterExtractor,
                        parameterTransformerMap, queryParameterBinder, templateTimeoutMap, personIdentifiers, pointInTimeUserType, applicationName, siteId, null );
        return queryWork;
    }
    
}
