

package gov.va.med.cds.exceptionframework;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;


/**
 *
 * Used for logging the exception to Default logger, its message and error id.
 *
 */
public class DefaultLogger
    implements
        ExceptionLoggerInterface
{
    private Log logger = LogFactory.getLog( DefaultLogger.class );


    /**
     * @see gov.va.med.cds.exceptionframework.ExceptionLoggerInterface#log(Throwable, LoggingSeverity, String, String, String)
     */
    public boolean log( List<ExceptionInfo> exceptionInfos, LoggingSeverity loggingSeverity, String entryPoint, String requestId,
                    String applicationName )
    {
        ExceptionUtil.logException( exceptionInfos, loggingSeverity, logger, entryPoint, requestId, applicationName );
        return true;
    }
        
    public boolean log( Exception exception, LoggingSeverity loggingSeverity, String message, String entryPoint, String requestId, String applicationName )
    {
        ExceptionUtil.logException( exception, loggingSeverity, logger, message, entryPoint, requestId, applicationName );
        return true;
    }
    /**
     *
     *
     * @see gov.va.med.cds.exceptionframework.ExceptionLoggerInterface#log(RuntimeException, String, String, String, String)
     */
    public boolean log( ExceptionInfo exceptionInfo, String message, String entryPoint, String requestId, String applicationName )
    {
        ExceptionUtil.logException( exceptionInfo, logger, message, entryPoint, requestId, applicationName );
        return true;
    }
    /**
    *
    *
    * @see gov.va.med.cds.exceptionframework.ExceptionLoggerInterface#log(RuntimeException, String, String, String, String)
    */
    public boolean log( Exception exception, String message, String entryPoint, String requestId, String applicationName )
   {
       ExceptionUtil.logException( exception, logger, message, entryPoint, requestId, applicationName );
       return true;
   }
}
