package gov.va.med.repositories;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


@WebService(name="Pathways", targetNamespace="http://repositories.med.DNS   /pathways")
@SOAPBinding(style=Style.RPC, use=Use.LITERAL, parameterStyle=ParameterStyle.BARE)
public interface Pathways
{
	
  /**
   * Check to see if system is runnings
   *
   * @return true if the system is running.
   */
	@WebMethod(operationName="isAlive")
    @RequestWrapper(className="java.lang.String")
    @ResponseWrapper(className="java.lang.Boolean")
	@WebResult(name="out")boolean isAlive( );


  /**
   * Synchronous version of a clinical data read
   *
   * @param templateId ID of the template for which the filter request applies
   * @param filterRequest Filter request specified in xml format according to the CDS filter schema
   * @param filterId ID of the named (canned) filter. The filterId may be null if no canned filter is referenced
   * @param requestId Client specified unique request Id
   * @return Results of the read returned in XML according to the CDS read results schema
   */
	@WebMethod(operationName="readData")
    @RequestWrapper(className="java.lang.String")
    @ResponseWrapper(className="java.lang.String")
    @WebResult(name="out")String readData( @WebParam(name="in0")String templateId, @WebParam(name="in1")String filterRequest, @WebParam(name="in2")String filterId, @WebParam(name="in3")String requestId );
	

	/***
	 * The calls executes write operations against the Pathways domains
	 * @param createXml is the Xml payload containing data to be persisted 
	 * @param templateId is the name of the Xml payload
	 * @param requestId id the unique id to track 
	 * @return
	 */
	@WebMethod(operationName="createData")
	@RequestWrapper(className="java.lang.String")
	@ResponseWrapper(className="java.lang.String")
	@WebResult(name="responseXml")String createData( @WebParam(name="createXml")String createXml, @WebParam(name="templateId")String templateId, @WebParam(name="requestId")String requestId);
}
