package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.requestresponse.generated.DMPTitleReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DMPTitleReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.DMPTitleType;
import gov.va.med.cds.ars.requestresponse.generated.DMPUniqueICNReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DMPUniqueICNReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.DistributionReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DistributionReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportSurveyType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.NationalDistributionReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.NationalDistributionReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.ObjectFactory;
import gov.va.med.cds.ars.requestresponse.generated.PSReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.PSReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.ReportIDType;
import gov.va.med.cds.ars.requestresponse.generated.TrendReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.TrendReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.VR12ReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.VR12ReportFilterType;
//import gov.va.med.cds.ars.requestresponse.generated.CensusWeeklyVendorStatusReportDataType;
//import gov.va.med.cds.ars.requestresponse.generated.CensusWeeklyVendorStatusReportFilterType;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


@RunWith(SuiteAwareSpringRunner.class)
@ContextConfiguration( locations = { 
                "/gov/va/med/cds/ars/config/arsPersistenceContext.xml", 
                "/gov/va/med/cds/ars/config/nonWeblogicHdrDataSourceContext.xml", 
                // "/gov/va/med/cds/ars/persistence/testPersistenceContext.xml" } )
				"/gov/va/med/cds/ars/config/exceptionHandlingConfigContext.xml",
				"/gov/va/med/cds/ars/config/filterContext.xml",
				"/gov/va/med/cds/ars/config/modelContext.xml",
				"/gov/va/med/cds/ars/config/jaxbContext.xml",
				"/gov/va/med/cds/ars/config/requestProcessorContext.xml" } )
                
public class ReadTest
    extends
        AbstractBaseTest
{
    private Map<String, ReadableReportsPersistenceManagerInterface> persistenceManagerMap = null;


    @Test
    @Suite( groups = { "checkintest" } )
    public void testPersistenceManagerMap( )
        throws Exception
    {
        Assert.assertNotNull( persistenceManagerMap );
    }
    

    private HTReportFilterType createVR12ReportFilter( )
        throws Exception
    {
        ObjectFactory objectFactory = new ObjectFactory();
        
        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();
        
        VR12ReportFilterType vr12ReportFilter = objectFactory.createVR12ReportFilterType();
        vr12ReportFilter.setReportID( ReportIDType.VR_12_STATISTICS );
        XMLGregorianCalendar startDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2000-01-20" );
        vr12ReportFilter.setStartDate( startDate );
        XMLGregorianCalendar endDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2013-05-30" );
        vr12ReportFilter.setEndDate( endDate );
        GeographicalAreaType geographicArea = objectFactory.createGeographicalAreaType();
        geographicArea.setLocation( "National" );
        vr12ReportFilter.setGeographicalArea( geographicArea );
        vr12ReportFilter.setSurveyVersion( "1.0" );
        vr12ReportFilter.setSurveyType( HTReportSurveyType.VR_12_ADL );
        
        htReportFilter.setVR12ReportFilter( vr12ReportFilter );
        
        return htReportFilter;
    }


    private HTReportFilterType createDistributionReportFilter( )
        throws Exception
    {
        ObjectFactory objectFactory = new ObjectFactory();
        
        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();
        
        DistributionReportFilterType distributionReportFilter = objectFactory.createDistributionReportFilterType();
        distributionReportFilter.setReportID( ReportIDType.DISTRIBUTION_OF_SURVEYS );
        XMLGregorianCalendar startDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2000-01-20" );
        distributionReportFilter.setStartDate( startDate );
        XMLGregorianCalendar endDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2013-05-30" );
        distributionReportFilter.setEndDate( endDate );
        GeographicalAreaType geographicArea = objectFactory.createGeographicalAreaType();
        geographicArea.setLocation( "National" );
        distributionReportFilter.setGeographicalArea( geographicArea );
        distributionReportFilter.setSurveyVersion( "1.0" );
        distributionReportFilter.setSurveyType( HTReportSurveyType.VR_12_ADL );
        
        htReportFilter.setDistributionReportFilter( distributionReportFilter );
        
        return htReportFilter;
    }


    private HTReportFilterType createPatientSatisfactionReportFilter( )
        throws Exception
    {
        ObjectFactory objectFactory = new ObjectFactory();
        
        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();
        
        PSReportFilterType patientSatisfactionReportFilter = objectFactory.createPSReportFilterType();
        patientSatisfactionReportFilter.setReportID( ReportIDType.PATIENT_SATISFACTION_STATISTICS );
        XMLGregorianCalendar startDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2000-01-20" );
        patientSatisfactionReportFilter.setStartDate( startDate );
        XMLGregorianCalendar endDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2013-05-30" );
        patientSatisfactionReportFilter.setEndDate( endDate );
        GeographicalAreaType geographicArea = objectFactory.createGeographicalAreaType();
        geographicArea.setLocation( "National" );
        patientSatisfactionReportFilter.setGeographicalArea( geographicArea );
        patientSatisfactionReportFilter.setSurveyVersion( "1.0" );
        patientSatisfactionReportFilter.setSurveyType( HTReportSurveyType.PATIENT_SATISFACTION );
        
        htReportFilter.setPatientSatisfactionReportFilter( patientSatisfactionReportFilter );
        
        return htReportFilter;
    }


    private HTReportFilterType createTrendReportFilter( )
        throws Exception
    {
        ObjectFactory objectFactory = new ObjectFactory();
        
        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();
        
        TrendReportFilterType trendReportFilter = objectFactory.createTrendReportFilterType();
        trendReportFilter.setReportID( ReportIDType.SURVEY_TRENDS );
        XMLGregorianCalendar startDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2000-01-20" );
        trendReportFilter.setStartDate( startDate );
        XMLGregorianCalendar endDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2013-05-30" );
        trendReportFilter.setEndDate( endDate );
        GeographicalAreaType geographicArea = objectFactory.createGeographicalAreaType();
        geographicArea.setLocation( "National" );
        trendReportFilter.setGeographicalArea( geographicArea );
        trendReportFilter.setSurveyVersion( "1.0" );
        trendReportFilter.setSurveyType( HTReportSurveyType.VR_12_ADL );
        
        htReportFilter.setSurveyTrendReportFilter( trendReportFilter );
        
        return htReportFilter;
    }


    private HTReportFilterType createNationalDistributionReportFilter( )
        throws Exception
    {
        ObjectFactory objectFactory = new ObjectFactory();
        
        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();
        
        NationalDistributionReportFilterType nationalDistributionReportFilter = objectFactory.createNationalDistributionReportFilterType();
        nationalDistributionReportFilter.setReportID( ReportIDType.NATIONAL_DISTRIBUTION_OF_SURVEYS );
        nationalDistributionReportFilter.setSurveyVersion( "1.0" );
        nationalDistributionReportFilter.setSurveyType( HTReportSurveyType.VR_12_ADL );
        
        htReportFilter.setNationalDistributionReportFilter( nationalDistributionReportFilter );
        
        return htReportFilter;
    }


    private HTReportFilterType createDMPUniqueICNReportFilter( )
        throws Exception
    {
        ObjectFactory objectFactory = new ObjectFactory();

        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();

        DMPUniqueICNReportFilterType dmpUniqueICNReportFilter = objectFactory.createDMPUniqueICNReportFilterType();
        dmpUniqueICNReportFilter.setReportID( ReportIDType.DMP_UNIQUE_ICN_REPORT );
        XMLGregorianCalendar startDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2000-01-20" );
        dmpUniqueICNReportFilter.setStartDate( startDate );
        XMLGregorianCalendar endDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2013-05-30" );
        dmpUniqueICNReportFilter.setEndDate( endDate );
        GeographicalAreaType geographicArea = objectFactory.createGeographicalAreaType();
        geographicArea.setLocation( "National" );
        dmpUniqueICNReportFilter.setGeographicalArea( geographicArea );
        dmpUniqueICNReportFilter.setSurveyVersion( "1.0" );
        dmpUniqueICNReportFilter.setSurveyType( "VHA_TEST_DMP_SURVEY" );
        dmpUniqueICNReportFilter.setVendor( "200T4" );
        
        htReportFilter.setDMPUniqueICNReportFilter( dmpUniqueICNReportFilter );
        
        return htReportFilter;
    }    

    
    private HTReportFilterType createDMPTitleReportFilter( )
        throws Exception
    {
        ObjectFactory objectFactory = new ObjectFactory();

        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();

        DMPTitleReportFilterType dmpUniqueICNReportFilter = objectFactory.createDMPTitleReportFilterType();
        dmpUniqueICNReportFilter.setReportID( ReportIDType.DMP_TITLE_REPORT );
        
        htReportFilter.setDMPTitleReportFilter( dmpUniqueICNReportFilter );
        
        return htReportFilter;
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVR12Report( )
            throws Exception
    {
        HTReportFilterType vr12ReportFilter = createVR12ReportFilter();
                
        ReadableReportsPersistenceManagerInterface vr12PersistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "VR-12_STATISTICS" );
        HTResponseType response = vr12PersistenceManager.performReadReportAggregate( vr12ReportFilter );
        VR12ReportDataType vr12Report = response.getVR12ReportData();
        ReportIDType reportID = vr12Report.getReportID();
        Assert.assertEquals( ReportIDType.VR_12_STATISTICS, reportID );
        Integer recordsConsidered = vr12Report.getNumberOfRecordsConsidered();
        Assert.assertNotNull( recordsConsidered );
    }

    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testDistributionReport( )
            throws Exception
    {
        HTReportFilterType distributionReportFilter = createDistributionReportFilter();
                
        ReadableReportsPersistenceManagerInterface distributionPersistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "DISTRIBUTION_OF_SURVEYS" );
        HTResponseType response = distributionPersistenceManager.performReadReportAggregate( distributionReportFilter );
        DistributionReportDataType distributionReport = response.getDistributionReportData();
        ReportIDType reportID = distributionReport.getReportID();
        Assert.assertEquals( ReportIDType.DISTRIBUTION_OF_SURVEYS, reportID );
        Integer recordsConsidered = distributionReport.getNumberOfRecordsConsidered();
        Assert.assertNotNull( recordsConsidered );
    }

    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testPatientSatisfactionReport( )
            throws Exception
    {
        HTReportFilterType patientSatisfactionReportFilter = createPatientSatisfactionReportFilter();
                
        ReadableReportsPersistenceManagerInterface patientSatisfactionPersistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "PATIENT_SATISFACTION_STATISTICS" );
        HTResponseType response = patientSatisfactionPersistenceManager.performReadReportAggregate( patientSatisfactionReportFilter );
        PSReportDataType patientSatisfactionReport = response.getPatientSatisfactionReportData();
        ReportIDType reportID = patientSatisfactionReport.getReportID();
        Assert.assertEquals( ReportIDType.PATIENT_SATISFACTION_STATISTICS, reportID );
        Integer recordsConsidered = patientSatisfactionReport.getNumberOfRecordsConsidered();
        Assert.assertNotNull( recordsConsidered );
    }

    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testTrendReport( )
            throws Exception
    {
        HTReportFilterType trendReportFilter = createTrendReportFilter();
                
        ReadableReportsPersistenceManagerInterface trendPersistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "SURVEY_TRENDS" );
        HTResponseType response = trendPersistenceManager.performReadReportAggregate( trendReportFilter );
        TrendReportDataType trendReport = response.getSurveyTrendReportData();
        ReportIDType reportID = trendReport.getReportID();
        Assert.assertEquals( ReportIDType.SURVEY_TRENDS, reportID );
        Integer recordsConsidered = trendReport.getNumberOfRecordsConsidered();
        Assert.assertNotNull( recordsConsidered );
    }

    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testNationalDistributionReport( )
            throws Exception
    {
        HTReportFilterType nationalDistributionReportFilter = createNationalDistributionReportFilter();
                
        ReadableReportsPersistenceManagerInterface nationalDistributionPersistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "NATIONAL_DISTRIBUTION_OF_SURVEYS" );
        HTResponseType response = nationalDistributionPersistenceManager.performReadReportAggregate( nationalDistributionReportFilter );
        NationalDistributionReportDataType nationalDistributionReport = response.getNationalDistributionReportData();
        ReportIDType reportID = nationalDistributionReport.getReportID();
        Assert.assertEquals( ReportIDType.NATIONAL_DISTRIBUTION_OF_SURVEYS, reportID );
        Integer recordsConsidered = nationalDistributionReport.getNumberOfRecordsConsidered();
        Assert.assertNotNull( recordsConsidered );
        recordsConsidered = nationalDistributionReport.getNumberOfVR12Records();
        Assert.assertNotNull( recordsConsidered );
        recordsConsidered = nationalDistributionReport.getNumberOfPatientSatisfactionRecords();
        Assert.assertNotNull( recordsConsidered );
    }

    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testDMPUniqueICNReport( )
            throws Exception
    {
        HTReportFilterType dmpUniqueICNReportFilter = createDMPUniqueICNReportFilter();
                
        ReadableReportsPersistenceManagerInterface dmpUniqueICNPersistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "DMP_UNIQUE_ICN_REPORT" );
        HTResponseType response = dmpUniqueICNPersistenceManager.performReadReportAggregate( dmpUniqueICNReportFilter );
        DMPUniqueICNReportDataType uniqueICNReport = response.getDMPUniqueICNReportData();
        ReportIDType reportID = uniqueICNReport.getReportID();
        Assert.assertEquals( ReportIDType.DMP_UNIQUE_ICN_REPORT, reportID );
        Integer recordsConsidered = uniqueICNReport.getNumberOfRecordsConsidered();
        Assert.assertNotNull( recordsConsidered );
    }

    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testDMPTitleReport( )
            throws Exception
    {
        HTReportFilterType dmpTitleReportFilter = createDMPTitleReportFilter();
                
        ReadableReportsPersistenceManagerInterface dmpTitlePersistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "DMP_TITLE_REPORT" );
        HTResponseType response = dmpTitlePersistenceManager.performReadReportAggregate( dmpTitleReportFilter );
        DMPTitleReportDataType titleReport = response.getDMPTitleReportData();
        ReportIDType reportID = titleReport.getReportID();
        Assert.assertEquals( ReportIDType.DMP_TITLE_REPORT, reportID );
        DMPTitleReportDataType.DmpTitles dmpTitles = titleReport.getDmpTitles();
        List<DMPTitleType> titleList = dmpTitles.getTitle();
        Assert.assertNotNull( titleList );
    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testCensusReportConfiguration(){
    	ReadableReportsPersistenceManagerInterface persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "CENSUS_WEEKLY_VENDOR_STATUS_REPORT");
    	Assert.assertNotNull(persistenceManager);
    	boolean b = (persistenceManager instanceof CensusWeeklyVendorStatusReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_POST_PROCESSING_STATUS_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusPostProcessingStatusReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_START_END_DATES_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusStartEndDatesReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.VENDOR_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof VendorReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.VISN_FACILITY_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof VISNFacilityReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.HTH_TRANSMITTALMODE_REPORT.value() );
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusTransmittalModeReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    }
    
    @Resource
    public void setPersistenceManagerMap( Map<String, ReadableReportsPersistenceManagerInterface> aPersistenceManagerMap )
    {
        this.persistenceManagerMap = aPersistenceManagerMap;
    }
    /*   
        private HTReportFilterType createCensusWeeklyVendorStatusReportFilter( ) throws Exception {
    	ObjectFactory objectFactory = new ObjectFactory();
        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();
	    CensusWeeklyVendorStatusReportFilterType filter = objectFactory.createCensusWeeklyVendorStatusReportFilterType();
	    filter.setReportID( ReportIDType.CENSUS_WEEKLY_VENDOR_STATUS_REPORT );
	    XMLGregorianCalendar startDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2014-07-13" );
	    filter.setStartDate( startDate );
	    XMLGregorianCalendar endDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2014-07-19" );
	    filter.setEndDate( endDate );
	    htReportFilter.setCensusWeeklyVendorReportStatusFilter(filter);
	    
	    return htReportFilter;
    }
    @Test
    @Suite( groups = { "checkintest" } )
    public void testCensusWeeklyVendorStatusReport( )
            throws Exception
    {
        HTReportFilterType filter = this.createCensusWeeklyVendorStatusReportFilter();
                
        ReadableReportsPersistenceManagerInterface persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "CENSUS_WEEKLY_VENDOR_STATUS_REPORT");
        HTResponseType response = persistenceManager.performReadReportAggregate( filter );
        CensusWeeklyVendorStatusReportDataType report = response.getCensusWeeklyVendorStatusReportData();
        ReportIDType reportID = report.getReportID();
        Assert.assertEquals( ReportIDType.CENSUS_WEEKLY_VENDOR_STATUS_REPORT, reportID );
        CensusWeeklyVendorStatusReportDataType.Vendors vendors = report.getVendors();
        Assert.assertNotNull( vendors );
    }

   */
    
    
}
