

package gov.va.med.cds.ars.persistence;


import gov.va.med.cds.ars.requestresponse.generated.VendorReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.VendorReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.ObjectFactory;
//import gov.va.med.cds.ars.requestresponse.generated.HTVendor;
import gov.va.med.cds.ars.requestresponse.generated.CensusVendorReportDataType;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;


public class VendorReportPersistenceManager extends AbstractReadableReportsPersistenceManager
	implements VendorReportPersistenceManagerInterface {
	
	protected String vendorQuery = "SurveyReports.Vendor";
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
    {
	   
        ObjectFactory objectFactory = new ObjectFactory();
        VendorReportDataType data = objectFactory.createVendorReportDataType();
        
        VendorReportDataType.Vendors vendor = objectFactory.createVendorReportDataTypeVendors();
        data.setVendors( vendor);
        VendorReportFilterType filter = aReportFilter.getVendorReportFilter();
        Session session = this.sessionFactory.getCurrentSession();     
        
        try
        {
            
        	List<CensusVendorReportDataType> results = null; 
            results = vendorReport( session, filter );
            data.getVendors().getVendor().addAll( results );
            data.setReportID( filter.getReportID() );
        }
        finally
        {
            session.close();
        }
        
        responseType.setVendorReportData( data );
        
        return responseType;
        
    }
    

    @SuppressWarnings( "unchecked" )
    private List<CensusVendorReportDataType> vendorReport( Session aSession, VendorReportFilterType aVendorReportFilterType  )
        throws PersistenceException
    {        
        Query query = aSession.getNamedQuery( vendorQuery );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug("+++++ Calling Census Vendor Repot stored proc: *****(  " + vendorQuery + "  )*****" );
        }
        
        List<CensusVendorReportDataType> results = ( List<CensusVendorReportDataType> )queryForReportData( query );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "----- Done with Census Vendor Report stored proc" );
        }

        return results;
    }


    public void setVendorQuery( String aVendorQuery  )
    {
        this.vendorQuery=  aVendorQuery ;
    }
}

