package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusTotalRuralVISNADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthVISNADCDataQuery = "SurveyReports.TotalRuralvisnAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusTotalRuralVISNADCReportFilterType filter = aReportFilter.getCensusTotalRuralVISNADCReportFilter();
		CensusTotalRuralVISNADCReportDataType data = new CensusTotalRuralVISNADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusTotalRuralVISNADCLocationReportDataType> results = null;

		try {
			results = getTotalRuralVISNADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusTotalRuralVISNADCReportData(data);

		return responseType;
	}    


    @SuppressWarnings("unchecked")
	private List<CensusTotalRuralVISNADCLocationReportDataType> getTotalRuralVISNADCData( Session aSession, CensusTotalRuralVISNADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthVISNADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthVISNADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusTotalRuralVISNADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusTotalRuralVISNADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getTotalRuralVISNADCData " + e);
		}
		
		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc" + hthVISNADCDataQuery);
		}

		return results;
	}

    public void setHthVISNADCDataQuery(String hthVISNADCDataQuery) {
		this.hthVISNADCDataQuery = hthVISNADCDataQuery;
	}
}

