

package gov.va.med.cds.ars.audit;


import gov.va.med.cds.audit.VhimReadResponseAuditLog;
import gov.va.med.cds.audit.persistence.AuditLogPersistenceManagerInterface;

import java.util.Date;


public class ReadAuditLogger
{
    protected AuditLogPersistenceManagerInterface auditLogPersistenceManager;


    public void setAuditLogPersistenceManager( AuditLogPersistenceManagerInterface auditLogPersistenceManager )
    {
        this.auditLogPersistenceManager = auditLogPersistenceManager;
    }


    public void recordAuditLog( Long startTime, String readResult, String reportRequest, String reportId, String clientId, String requestId )
    {
    	VhimReadResponseAuditLog auditLog = null;
    	auditLog = buildVhimAuditLog( startTime, readResult, reportRequest, reportId, clientId, requestId );
        recordAuditLog( auditLog );
    }


    public void recordAuditLog( VhimReadResponseAuditLog auditLog )
    {
        auditLogPersistenceManager.storeAuditLog( auditLog );
    }

	
    public VhimReadResponseAuditLog buildVhimAuditLog( Long startTime, String readResult, String reportRequest, String reportId, String clientId,	String requestId )
    {
        VhimReadResponseAuditLog auditLog = new VhimReadResponseAuditLog();
        auditLog.setEndTime( new Date().getTime() );
        auditLog.setLocalTime( new Date() );
        auditLog.setTemplateId( reportId ); 
        auditLog.setFilterRequest( reportRequest ); 
        auditLog.setFilterId( "HTReportFilter" ); 
        auditLog.setResponse( readResult ); 
        auditLog.setRequestId( requestId ); 
        auditLog.setSendingApplication( clientId ); 
        auditLog.setStartTime( startTime ); 
        auditLog.setClientId( clientId ); 

        return auditLog;
    }

}
