<?xml version="1.0"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:results="Results" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:map="map:java.util.Map" xmlns:hdr="json" xmlns:clinicaldata="Clinicaldata" exclude-result-prefixes="xsi results xs fn map hdr">
	<xsl:output indent="yes" encoding="UTF-8" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:variable name="quot" select="'&quot;'"/>
	<xsl:template match="/ClinicalData">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="observationValue">
		<xsl:call-template name="object">
			<xsl:with-param name="json-in" select="."/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="field">
		<!-- Input like: "Open": "25.15" bla -->
		<!-- output like: <output><Open>25.15</Open></output> <extra>bla</extra> -->
		<xsl:param name="json-in"/>
		<xsl:variable name="field-name" select="substring-before(substring-after($json-in,$quot),$quot)"/>
		<xsl:variable name="remainder" select="substring-after($json-in,':')"/>
		<xsl:call-template name="value">
			<xsl:with-param name="json-in" select="$remainder"/>
			<xsl:with-param name="parent-ele" select="$field-name"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="fields">
		<!-- Input like: "Open": "25.15" , "High": "25.15" } bla -->
		<!-- output like: <output><Open>25.15</Open><High>25.15</High></output> <extra>} bla</extra> -->
		<xsl:param name="json-in"/>
		<xsl:variable name="n" select="normalize-space($json-in)"/>
		<xsl:choose>
			<xsl:when test="substring($n,1,1) = $quot">
				<xsl:variable name="t1">
					<xsl:call-template name="field">
						<xsl:with-param name="json-in" select="$n"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="t2" select="normalize-space( ($t1)/extra) "/>
				<xsl:variable name="t3">
					<xsl:choose>
						<xsl:when test="substring($t2,1,1)=','">
							<xsl:call-template name="fields">
								<xsl:with-param name="json-in" select="substring-after($t2,',')"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$t2">
							<extra>
								<xsl:value-of select="$t2"/>
							</extra>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<observationValue>
					<xsl:copy-of select="($t1)/observationValue/* | ($t3)/observationValue/*"/>
				</observationValue>
				<xsl:copy-of select="($t3)/extra"/>
			</xsl:when>
			<xsl:when test="$n">
				<extra>
					<xsl:value-of select="$n"/>
				</extra>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="objects">
		<xsl:param name="json-in"/>
		<xsl:param name="parent-ele"/>
		<xsl:variable name="n" select="normalize-space($json-in)"/>
		<xsl:choose>
			<xsl:when test="substring($n,1,1) = '{'">
				<xsl:variable name="t1">
					<xsl:call-template name="object">
						<xsl:with-param name="json-in" select="$n"/>
						<xsl:with-param name="parent-ele" select="$parent-ele"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="t2" select="normalize-space( ($t1)/extra) "/>
				<xsl:variable name="t3">
					<xsl:choose>
						<xsl:when test="matches($t2, '^,\s*\{') ">
							<xsl:call-template name="objects">
								<xsl:with-param name="json-in" select="substring-after($t2,',')"/>
								<xsl:with-param name="parent-ele" select="$parent-ele"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="substring($t2,1,1)='{'">
							<xsl:call-template name="objects">
								<xsl:with-param name="json-in" select="$t2"/>
								<xsl:with-param name="parent-ele" select="$parent-ele"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$t2">
							<extra>
								<xsl:value-of select="$t2"/>
							</extra>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<observationValue>
					<xsl:copy-of select="($t1)/observationValue/* | ($t3)/observationValue/*"/>
				</observationValue>
				<xsl:copy-of select="($t3)/extra"/>
			</xsl:when>
			<xsl:when test="$n">
				<extra>
					<xsl:value-of select="$n"/>
				</extra>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="array">
		<!-- Input like: [ X1 X2 ] bla -->
		<!-- output like: <output><Y>X1</Y><Y>X2</Y></output> <extra>}bla</extra> -->
		<xsl:param name="json-in"/>
		<xsl:param name="parent-ele"/>
		<xsl:variable name="t1" select="normalize-space(substring-after($json-in,'['))"/>
		<xsl:variable name="t2">
			<xsl:call-template name="objects">
				<xsl:with-param name="json-in" select="$t1"/>
				<xsl:with-param name="parent-ele" select="$parent-ele"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="t3" select="normalize-space(substring-after( ($t2)/extra, ']'))"/>
		<xsl:copy-of select="($t2)/observationValue"/>
		<xsl:if test="$t3">
			<extra>
				<xsl:value-of select="$t3"/>
			</extra>
		</xsl:if>
	</xsl:template>
	<xsl:template name="value">
		<!-- Input like either array, object, string, integer or boolean-->
		<!-- output like either array, object, string, integer or boolean -->
		<xsl:param name="json-in"/>
		<xsl:param name="parent-ele"/>
		<xsl:variable name="first-letter" select="substring(normalize-space($json-in),1,1)"/>
		<xsl:choose>
			<xsl:when test="$first-letter='{'">
				<xsl:call-template name="object">
					<xsl:with-param name="json-in" select="$json-in"/>
					<xsl:with-param name="parent-ele" select="$parent-ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$first-letter='['">
				<xsl:call-template name="array">
					<xsl:with-param name="json-in" select="$json-in"/>
					<xsl:with-param name="parent-ele" select="$parent-ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$first-letter=$quot">
				<xsl:call-template name="string">
					<xsl:with-param name="json-in" select="$json-in"/>
					<xsl:with-param name="parent-ele" select="$parent-ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains('0123456789', $first-letter)">
				<xsl:call-template name="integer">
					<xsl:with-param name="json-in" select="$json-in"/>
					<xsl:with-param name="parent-ele" select="$parent-ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains('tfTF', $first-letter)">
				<xsl:call-template name="boolean">
					<xsl:with-param name="json-in" select="$json-in"/>
					<xsl:with-param name="parent-ele" select="$parent-ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<observationValue>ERROR</observationValue>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="string">
		<!-- Input like: "X" bla -->
		<!-- output like: <output><Y>X</Y></output> <extra>bla</extra> -->
		<xsl:param name="json-in"/>
		<xsl:param name="parent-ele"/>
		<xsl:variable name="value" select="substring-before(substring-after($json-in,$quot),$quot)"/>
		<xsl:variable name="remainder" select="normalize-space(substring-after(substring-after($json-in,$quot),$quot))"/>
		<observationValue>
			<xsl:element name="{$parent-ele}">
				<xsl:value-of select="$value"/>
			</xsl:element>
		</observationValue>
		<xsl:if test="$remainder">
			<extra>
				<xsl:value-of select="$remainder"/>
			</extra>
		</xsl:if>
	</xsl:template>
	<xsl:template name="integer">
		<!-- Input like: \d\d\d bla -->
		<!-- output like: <output><Y>\d\d\d</Y></output> <extra>bla</extra> -->
		<xsl:param name="json-in"/>
		<xsl:param name="parent-ele"/>
		<xsl:variable name="value1" select="normalize-space(substring-before($json-in,','))"/>
		<xsl:variable name="value2" select="normalize-space(substring-before($json-in,'}'))"/>
		<xsl:variable name="value3" select="normalize-space(substring-before($json-in,']'))"/>
		<xsl:variable name="lgNbr" select="10000" as="xs:integer"/>
		<xsl:variable name="len1" as="xs:integer">
			<xsl:choose>
				<xsl:when test="$value1">
					<xsl:value-of select="string-length($value1)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$lgNbr"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="len2" as="xs:integer">
			<xsl:choose>
				<xsl:when test="$value2">
					<xsl:value-of select="string-length($value2)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$lgNbr"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="len3" as="xs:integer">
			<xsl:choose>
				<xsl:when test="$value3">
					<xsl:value-of select="string-length($value3)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$lgNbr"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="value">
			<xsl:choose>
				<xsl:when test="(($len1 &lt; $len2) and ($len1 &lt; $len3))">
					<xsl:value-of select="$value1"/>					
				</xsl:when>
				<xsl:when test="(($len2 &lt; $len1) and ($len2 &lt; $len3))">
					<xsl:value-of select="$value2"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$value3"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="remainder" select="normalize-space(substring-after($json-in,$value))"/>
		<observationValue>
			<xsl:element name="{$parent-ele}">
				<xsl:value-of select="$value"/>
			</xsl:element>
		</observationValue>
		<xsl:if test="$remainder">
			<extra>
				<xsl:value-of select="$remainder"/>
			</extra>
		</xsl:if>
	</xsl:template>
	<xsl:template name="boolean">
		<!-- Input like: true|false|True|False bla -->
		<!-- output like: <output><Y>true|false|True|False</Y></output> <extra>bla</extra> -->
		<xsl:param name="json-in"/>
		<xsl:param name="parent-ele"/>
		<xsl:variable name="first-letter" select="lower-case(substring(normalize-space($json-in),1,1))"/>
		<xsl:variable name="tval" select="string('true')"/>
		<xsl:variable name="fval" select="string('false')"/>
		<xsl:variable name="value">
			<xsl:choose>
				<xsl:when test="$first-letter='t'">
					<xsl:value-of select="$tval"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$fval"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="remainder" select="normalize-space(substring-after($json-in,$value))"/>
		<observationValue>
			<xsl:element name="{$parent-ele}">
				<xsl:value-of select="$value"/>
			</xsl:element>
		</observationValue>
		<xsl:if test="$remainder">
			<extra>
				<xsl:value-of select="$remainder"/>
			</extra>
		</xsl:if>
	</xsl:template>
	<xsl:template name="object">
		<!-- Input like: { X } bla -->
		<!-- output like: <output>fields(X)</output> <extra>bla</extra> -->
		<xsl:param name="json-in"/>
		<xsl:param name="parent-ele" select="''"/>
		<xsl:variable name="t1" select="normalize-space(substring-after($json-in,'{'))"/>
		<xsl:variable name="t2">
			<xsl:call-template name="fields">
				<xsl:with-param name="json-in" select="$t1"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="t3" select="normalize-space(substring-after( ($t2)/extra, '}'))"/>
		<observationValue>
			<xsl:choose>
				<xsl:when test="$parent-ele">
					<xsl:element name="{$parent-ele}">
						<xsl:copy-of select="($t2)/observationValue/node()"/>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="($t2)/observationValue/node()"/>
				</xsl:otherwise>
			</xsl:choose>
		</observationValue>
		<xsl:if test="$t3">
			<extra>
				<xsl:value-of select="$t3"/>
			</extra>
		</xsl:if>
	</xsl:template>
	<xsl:template match="@* | node()">
		<xsl:copy>
			<xsl:apply-templates select="@* | node()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>