/**
 * 
 */
package gov.va.med.cds.testharness.xml;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * @author DNS   egberb
 *
 */
@RunWith( SuiteAwareRunner.class )
public class SchemaHelperTest
{
    @Test
    public void testVWPharmacyDetailRead40010ClinicalDataIsValidPath() throws Exception
    {
        SchemaHelper schemaHelper = SchemaHelper.createSchemaHelper( "../../core/main/templatecache/vhim_4_00", "VWPharmacyDetailRead40010" );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/templateId" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/requestId" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/errorSection" ) );
    }
    
    @Test
    public void testLoadVWPharmacyDetailRead40010ClinicalDataPatientIsValidPath() throws Exception
    {
        SchemaHelper schemaHelper = SchemaHelper.createSchemaHelper( "../../core/main/templatecache/vhim_4_00", "VWPharmacyDetailRead40010" );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/requestedNationalId" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/requestedResolvedIdentifiers" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/requestedExcludedIdentifiers" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/resultantIdentifiers" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises" ) );
    }
    
    @Test
    public void testLoadVWPharmacyDetailRead40010ClinicalDataPatientOutpatientMedicationPromiseIsValidPath() throws Exception
    {
        SchemaHelper schemaHelper = SchemaHelper.createSchemaHelper( "../../core/main/templatecache/vhim_4_00", "VWPharmacyDetailRead40010" );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/patient" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/numberOfRefillsAuthorized" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/sig" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/originalDispense" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/refillDispense" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/cancel" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/recordSource" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/recordVersion" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/recordUpdateTime" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/recordIdentifier" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/prescriptionId" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/pharmacyRequest" ) );
        
    }
    
   @Test
    public void testLoadVWPharmacyDetailRead40010ClinicalDataPatientOutpatientMedicationPromisePatientIsValidPath() throws Exception
    {
        SchemaHelper schemaHelper = SchemaHelper.createSchemaHelper( "../../core/main/templatecache/vhim_4_00", "VWPharmacyDetailRead40010" );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/patient" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/patient/identifier" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/patient/identifier/identity" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/patient/identifier/assigningFacility" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patient/outpatientMedicationPromises/patient/identifier/assigningAuthority" ) );
    }
    
    //@Test
    public void testLoadHealthAdapterRead1PatientEnterVitalSignsIsValidPath() throws Exception
    {
        SchemaHelper schemaHelper = SchemaHelper.createSchemaHelper( "../../core/main/templatecache/vhim_4_00", "HealthAdapterRead1" );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/templateId" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/requestId" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/errorSection" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/comments" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/dataEnterer" ) );
        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/vitalSignObservationEvent" ) );
//        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/vitalSignObservationEvent/patient" ) );
//        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/vitalSignObservationEvent/patient/identifier/identity" ) );
//        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/vitalSignObservationEvent/patient/identifier/assigningFacility" ) );
//        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/vitalSignObservationEvent/patient/identifier/assigningAuthority" ) );
//        Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/vitalSignObservationEvent/observationTime" ) ); 
     // Assert.assertTrue( schemaHelper.isPathValidForSchema( "ClinicalData/patients/patient/patientEnteredVitalSigns/patientEnteredVitalSign/vitalSignObservationEvent/vitalSignObservation/qualifiers" ) );
    }
}
