/**
 * 
 */


package gov.va.med.cds.testharness.xml;


import static org.junit.Assert.assertNotNull;

import gov.va.med.cds.exceptionframework.LoggingSeverity;
import gov.va.med.cds.testharness.xml.XpathAsserterFactory.VHIM_VERSION;

import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;


/**
 * @author DNS   egberb
 *
 */
public class Assert
    extends
        org.junit.Assert
{

    public static void assertXpathCompare( String xml, String xpathExpression, String controlResult )
    {
        try
        {
            XpathAsserterFactory.createXpathAsserter( VHIM_VERSION.VHIM_400 ).assertXpathCompare( xml, xpathExpression, controlResult );
        }
        catch ( Exception e )
        {
            fail( e.getMessage() );
        }
    }


    public static void assertXmlEquals( String sourceXml, String controlXml )
    {
        try
        {
            XmlComparator.assertXMLSimilar( sourceXml, controlXml );
        }
        catch ( XmlCompareException e )
        {
            fail( e.getMessage() );
        }
    }


    public static void assertXmlEquals( String sourceXml, String controlXml, List<String> excludes )
    {
        try
        {
            XmlComparator.assertXMLSimilar( sourceXml, controlXml, excludes );
        }
        catch ( XmlCompareException e )
        {
            fail( e.getMessage() );
        }
    }


    public static void assertXmlEqualsAfterRemovingAllEmptyElements( String sourceXml, String controlXml, List<String> excludes )
    {
        try
        {
            XmlComparator.assertXMLSimilarAfterRemovingAllEmptyElements( sourceXml, controlXml, excludes );
        }
        catch ( XmlCompareException e )
        {
            fail( e.getMessage() );
        }
    }
    
    
    public static void assertXmlSimilar( String sourceXml, String controlXml )
    {
        try
        {
            XmlComparator.assertXMLSimilar( sourceXml, controlXml );
        }
        catch ( XmlCompareException e )
        {
            fail( e.getMessage() );
        }
    }


    public static void assertXmlValidation( String xml, String templateId )
    {
        try
        {
            XmlValidator.validateXml(xml, templateId);
        }
        catch ( Exception e )
        {
            fail( e.getMessage() );
        }
    }
    
    
    public static void assertXmlValidation( String xml, String templateId, String schemaNamespace )
    {
        try
        {
            XmlValidator.validateXml(xml, templateId, schemaNamespace);
        }
        catch ( Exception e )
        {
            fail( e.getMessage() );
        }
    }


    public static void assertXmlErrorSectionEquals( String sourceXml, String controlXml )
    {
        assertXmlErrorSectionEquals( sourceXml, controlXml, null );
    }


    public static void assertXmlErrorSectionEquals( String sourceXml, String controlXml, List<String> excludes )
    {
        try
        {
            XmlComparator.assertXMLSimilar( sourceXml, controlXml, excludes );
        }
        catch ( XmlCompareException e )
        {
            fail( e.getMessage() );
        }
    }


    public static void assertHasFatalErrors( String xmlClinicalData )
    {
        try
        {
            Document clinicalData = DocumentHelper.parseText( xmlClinicalData );
            assertTrue( clinicalData.selectNodes( "/ClinicalData/errorSection/fataErrors" ).size() > 0 );
        }
        catch ( DocumentException e )
        {
            fail( e.getMessage() );
        }
    }


    public static void assertNoErrors( String xmlClinicalData )
    {
        try
        {
            Document clinicalData = DocumentHelper.parseText( xmlClinicalData );
            assertTrue( clinicalData.selectNodes( "/ClinicalData/errorSection/*" ).size() == 0 );
        }
        catch ( DocumentException e )
        {
            fail( e.getMessage() );
        }
    }

    public static void assertErrors( String xmlClinicalData, LoggingSeverity serverity, int count )
    {
        try
        {
            Document clinicalData = DocumentHelper.parseText( xmlClinicalData );

            switch ( serverity )
            {
            case FATAL:
                assertEquals( clinicalData.selectNodes( "/ClnicalData/errorSection/fatalErrors" ), count );
                break;
            case ERROR:
                assertEquals( clinicalData.selectNodes( "/ClnicalData/errorSection/errors" ), count );
                break;
            case WARNING:
                assertEquals( clinicalData.selectNodes( "/ClnicalData/errorSection/warnings" ), count );
                break;
            default:
                fail();
            }
        }
        catch ( DocumentException e )
        {
            fail( e.getMessage() );
        }
    }
}
